/*
 * Decompiled with CFR 0.152.
 */
package io.preboot.eventbus;

import io.preboot.eventbus.AsynchronousEventPublisher;
import io.preboot.eventbus.ExceptionIfNoHandler;
import io.preboot.eventbus.LocalEventHandlerRepository;
import io.preboot.eventbus.NoEventHandlerException;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalAsynchronousEventPublisher
implements AsynchronousEventPublisher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalAsynchronousEventPublisher.class);
    private final LocalEventHandlerRepository localEventHandlerRepository;
    private final Executor executor;

    public LocalAsynchronousEventPublisher(LocalEventHandlerRepository localEventHandlerRepository, Executor executor) {
        this.localEventHandlerRepository = localEventHandlerRepository;
        this.executor = executor;
    }

    @Override
    public <T> void publish(T event) {
        if (this.localEventHandlerRepository.isHandlerMissing(event)) {
            if (event.getClass().getAnnotation(ExceptionIfNoHandler.class) != null) {
                throw new NoEventHandlerException(event);
            }
            log.warn("No handler found for event: {}", event);
            return;
        }
        if (this.executor != null) {
            this.executor.execute(() -> this.localEventHandlerRepository.publish(event));
            return;
        }
        throw new IllegalStateException("Executor implementation is not provided");
    }
}

