/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.service.visitor;

import com.fasterxml.jackson.databind.type.TypeFactory;
import io.polyapi.plugin.model.ParsedType;
import io.polyapi.plugin.model.type.PolyType;
import io.polyapi.plugin.model.type.basic.ArrayPolyType;
import io.polyapi.plugin.model.type.basic.PlainPolyType;
import io.polyapi.plugin.model.type.basic.VoidPolyType;
import io.polyapi.plugin.model.type.complex.MapObjectPolyType;
import io.polyapi.plugin.model.type.complex.SchemaObjectPolyType;
import io.polyapi.plugin.model.type.function.FunctionPolyType;
import io.polyapi.plugin.model.type.primitive.PrimitivePolyType;
import io.polyapi.plugin.model.visitor.TypeVisitor;
import io.polyapi.plugin.service.schema.JsonSchemaParser;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeExtractionVisitor
implements TypeVisitor {
    private static final Logger log = LoggerFactory.getLogger(TypeExtractionVisitor.class);
    private final String defaultName;
    private final JsonSchemaParser jsonSchemaParser;
    private final String basePackage;
    private ParsedType result;

    public TypeExtractionVisitor(String defaultName, String basePackage, JsonSchemaParser jsonSchemaParser) {
        this.defaultName = defaultName;
        this.basePackage = basePackage;
        this.jsonSchemaParser = jsonSchemaParser;
    }

    public void doVisit(PolyType type) {
        log.debug("Extracting type for {}.", (Object)type.getKind());
        if (this.result != null) {
            throw new UnsupportedOperationException(String.format("This visitor has already resolved to '%s' and cannot be reused.", this.result));
        }
        type.accept(this);
        log.debug("Type for {} extracted.", (Object)type.getKind());
    }

    @Override
    public void visit(PolyType polyType) {
        log.trace("Extracting type from PolyType.");
        this.result = new ParsedType((Type)((Object)Object.class));
    }

    @Override
    public void visit(SchemaObjectPolyType type) {
        log.trace("Extracting type from SchemaObjectPolyType.");
        this.result = this.jsonSchemaParser.getType(this.defaultName, this.basePackage, type.getSchema());
    }

    @Override
    public void visit(MapObjectPolyType type) {
        log.trace("Extracting type from MapObjectPolyType.");
        this.result = new ParsedType((Type)TypeFactory.defaultInstance().constructMapType(Map.class, String.class, Object.class));
    }

    @Override
    public void visit(PlainPolyType type) {
        this.result = Optional.ofNullable(type).map(PlainPolyType::getValue).filter(Predicate.not(Predicate.isEqual("void"))).map(plainType -> new ParsedType((Type)((Object)Object.class))).orElse(new ParsedType((Type)((Object)Void.class)));
    }

    @Override
    public void visit(VoidPolyType type) {
        log.trace("Extracting type from VoidPolyType.");
        this.result = new ParsedType((Type)((Object)Void.class));
    }

    @Override
    public void visit(ArrayPolyType type) {
        log.trace("Extracting type from ArrayPolyType.");
        this.doVisit(type.getItems());
        this.result = new ParsedType(List.class.getName(), List.of(this.result));
    }

    @Override
    public void visit(PrimitivePolyType type) {
        log.trace("Extracting type from PrimitivePolyType.");
        this.result = new ParsedType(type.getType().getTypeName());
    }

    @Override
    public void visit(FunctionPolyType type) {
        log.trace("Extracting type from FunctionPolyType.");
        this.result = new ParsedType((Type)((Object)Object.class));
    }

    public ParsedType getResult() {
        return this.result;
    }
}

