/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.service.visitor;

import io.polyapi.commons.api.json.JsonParser;
import io.polyapi.plugin.model.generation.Generable;
import io.polyapi.plugin.model.generation.KeyValuePair;
import io.polyapi.plugin.model.generation.PropertiesObject;
import io.polyapi.plugin.model.type.PolyType;
import io.polyapi.plugin.model.type.complex.PropertiesObjectPolyType;
import io.polyapi.plugin.model.type.complex.SchemaObjectPolyType;
import io.polyapi.plugin.model.type.function.FunctionSpecPolyType;
import io.polyapi.plugin.model.visitor.TypeVisitor;
import io.polyapi.plugin.service.FileService;
import io.polyapi.plugin.service.schema.JsonSchemaParser;
import io.polyapi.plugin.service.visitor.ImportsCollectorVisitor;
import io.polyapi.plugin.service.visitor.TypeExtractionVisitor;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeCodeGeneratorVisitor
implements TypeVisitor {
    private static final Logger log = LoggerFactory.getLogger(TypeCodeGeneratorVisitor.class);
    private final FileService fileService;
    private final JsonParser jsonParser;
    private final JsonSchemaParser jsonSchemaParser;
    private final String defaultName;
    private final String basePackage;
    private final boolean overwriteFiles;

    public void doVisit(PolyType type) {
        log.debug("Generating code for {}.", (Object)type.getKind());
        type.accept(this);
        log.debug("Code for {} generated.", (Object)type.getKind());
    }

    public void doVisit(FunctionSpecPolyType function) {
        log.debug("Generating code for {} types.", (Object)((long)function.getArguments().size() + Optional.ofNullable(function.getReturnType()).stream().count()));
        function.accept(this);
        log.debug("Code generated.");
    }

    @Override
    public void visit(SchemaObjectPolyType type) {
        log.trace("Generating code for schema type with schema:\n{}.", (Object)type.getSchema());
        String schema = Optional.ofNullable(type.getSchema()).map(Object::toString).orElse("").replace(">", "_").replace("<", "_");
        boolean withinQuotes = false;
        StringBuilder builder = new StringBuilder();
        for (char c : schema.toCharArray()) {
            if (c == '\"') {
                boolean bl = withinQuotes = !withinQuotes;
            }
            if (c == '.' && withinQuotes) {
                builder.append('_');
                continue;
            }
            builder.append(c);
        }
        schema = builder.toString();
        this.jsonSchemaParser.parse(this.defaultName, this.basePackage, schema).forEach(customType -> this.fileService.generateFile((Generable)customType, this.overwriteFiles));
    }

    @Override
    public void visit(PropertiesObjectPolyType type) {
        log.trace("Generating code for properties object type with properties:\n{}.", type.getProperties());
        ImportsCollectorVisitor importsCollectorVisitor = new ImportsCollectorVisitor(this.basePackage, this.defaultName, this.jsonSchemaParser);
        importsCollectorVisitor.doVisit((PolyType)PolyType.class.cast(type));
        Set<String> imports = importsCollectorVisitor.getImports();
        ArrayList<KeyValuePair<String, String>> properties = new ArrayList<KeyValuePair<String, String>>();
        type.getProperties().forEach(property -> {
            TypeExtractionVisitor typeExtractionVisitor = new TypeExtractionVisitor(this.defaultName, this.basePackage, this.jsonSchemaParser);
            property.accept(typeExtractionVisitor);
            properties.add(new KeyValuePair<String, String>(property.getName(), typeExtractionVisitor.getResult().getFullName()));
        });
        PropertiesObject propertiesObject = new PropertiesObject(this.basePackage, imports, this.defaultName, properties);
        this.fileService.generateFile(propertiesObject, this.overwriteFiles);
        IntStream.range(0, type.getProperties().size()).forEach(i -> {
            String childPropertyDefaultClassName = String.format("%sAttr%s", this.defaultName, i);
            type.getProperties().forEach(property -> property.accept(new TypeCodeGeneratorVisitor(this.fileService, this.jsonParser, this.jsonSchemaParser, childPropertyDefaultClassName, this.basePackage, this.overwriteFiles)));
        });
    }

    @Override
    public void visit(FunctionSpecPolyType type) {
        log.trace("Generating code for FunctionSpecPolyType.");
        Optional.ofNullable(type.getReturnType()).ifPresent(returnType -> returnType.accept(new TypeCodeGeneratorVisitor(this.fileService, this.jsonParser, this.jsonSchemaParser, String.format("%sResult", this.defaultName), this.basePackage, this.overwriteFiles)));
        IntStream.range(0, type.getArguments().size()).forEach(i -> type.getArguments().get(i).accept(new TypeCodeGeneratorVisitor(this.fileService, this.jsonParser, this.jsonSchemaParser, String.format("%sArg%s", this.defaultName, i), this.basePackage, this.overwriteFiles)));
    }

    public TypeCodeGeneratorVisitor(FileService fileService, JsonParser jsonParser, JsonSchemaParser jsonSchemaParser, String defaultName, String basePackage, boolean overwriteFiles) {
        this.fileService = fileService;
        this.jsonParser = jsonParser;
        this.jsonSchemaParser = jsonSchemaParser;
        this.defaultName = defaultName;
        this.basePackage = basePackage;
        this.overwriteFiles = overwriteFiles;
    }
}

