/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.service.visitor;

import io.polyapi.commons.api.json.JsonParser;
import io.polyapi.commons.api.model.PolyGeneratedClass;
import io.polyapi.plugin.model.function.CodeObject;
import io.polyapi.plugin.model.generation.CustomType;
import io.polyapi.plugin.model.specification.Specification;
import io.polyapi.plugin.model.specification.function.ClientFunctionSpecification;
import io.polyapi.plugin.model.specification.function.FunctionSpecification;
import io.polyapi.plugin.model.specification.function.ServerFunctionSpecification;
import io.polyapi.plugin.model.specification.resolved.ResolvedCustomFunctionSpecification;
import io.polyapi.plugin.model.specification.resolved.ResolvedServerVariableSpecification;
import io.polyapi.plugin.model.specification.resolved.ResolvedSpecification;
import io.polyapi.plugin.model.specification.resolved.ResolvedWebhookHandleSpecification;
import io.polyapi.plugin.model.specification.variable.ServerVariableSpecification;
import io.polyapi.plugin.model.specification.webhook.WebhookHandleSpecification;
import io.polyapi.plugin.model.type.function.FunctionPolyType;
import io.polyapi.plugin.model.visitor.PolySpecificationVisitor;
import io.polyapi.plugin.service.FileService;
import io.polyapi.plugin.service.generation.PolyObjectResolverService;
import io.polyapi.plugin.service.schema.JsonSchemaParser;
import io.polyapi.plugin.service.visitor.PolyObjectResolverVisitor;
import io.polyapi.plugin.service.visitor.TypeCodeGeneratorVisitor;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificationCodeGeneratorVisitor
implements PolySpecificationVisitor {
    private static final Logger log = LoggerFactory.getLogger(SpecificationCodeGeneratorVisitor.class);
    private final JsonSchemaParser jsonSchemaParser;
    private final JsonParser jsonParser;
    private final PolyObjectResolverService resolver;
    private final FileService fileService;
    private final boolean overwriteFiles;

    public SpecificationCodeGeneratorVisitor(FileService fileService, PolyObjectResolverService resolver, JsonParser jsonParser, JsonSchemaParser jsonSchemaParser, boolean overwriteFiles) {
        this.fileService = fileService;
        this.resolver = resolver;
        this.jsonParser = jsonParser;
        this.jsonSchemaParser = jsonSchemaParser;
        this.overwriteFiles = overwriteFiles;
    }

    @Override
    public void doVisit(Specification specification) {
        log.debug("Generating code for {} specification '{}' on context '{}'.", new Object[]{specification.getType(), specification.getName(), specification.getContext()});
        specification.accept(this);
        log.debug("Code for {} specification '{}' on context '{}' generated.", new Object[]{specification.getType(), specification.getName(), specification.getContext()});
    }

    @Override
    public void visit(FunctionSpecification specification) {
        log.trace("Generating code for FunctionSpecification.");
        PolyObjectResolverVisitor visitor = new PolyObjectResolverVisitor(this.resolver);
        visitor.doVisit(specification);
        ResolvedSpecification resolvedSpecification = visitor.getResult();
        this.fileService.generateFile(resolvedSpecification, this.overwriteFiles);
        new TypeCodeGeneratorVisitor(this.fileService, this.jsonParser, this.jsonSchemaParser, resolvedSpecification.getClassName(), resolvedSpecification.getPackageName(), this.overwriteFiles).doVisit(specification.getFunction());
    }

    @Override
    public void visit(ServerFunctionSpecification specification) {
        log.trace("Generating code for ServerFunctionSpecification.");
        this.visit((FunctionSpecification)FunctionSpecification.class.cast(specification));
    }

    @Override
    public void visit(ClientFunctionSpecification specification) {
        log.trace("Generating code for CustomFunctionSpecification.");
        ResolvedCustomFunctionSpecification resolvedSpecification = this.resolver.resolve(specification);
        this.fileService.generateFile(resolvedSpecification, this.overwriteFiles);
        specification.getFunction().accept(new TypeCodeGeneratorVisitor(this.fileService, this.jsonParser, this.jsonSchemaParser, resolvedSpecification.getClassName(), resolvedSpecification.getPackageName(), this.overwriteFiles));
        CodeObject codeObject = Optional.of(specification.getCode()).map(String::trim).filter(code -> code.startsWith("{")).map(code -> (CodeObject)this.jsonParser.parseString(specification.getCode(), CodeObject.class)).orElseGet(() -> {
            CodeObject result = new CodeObject();
            result.setCode(specification.getCode().replace("PolyCustomFunction", resolvedSpecification.getClassName()));
            result.setClassName(resolvedSpecification.getClassName());
            return result;
        });
        codeObject.setPackageName(String.format("%s.delegate", resolvedSpecification.getPackageName()));
        codeObject.setCode(codeObject.getCode().replace("public class", String.format("@%s\npublic class", PolyGeneratedClass.class.getName())));
        this.fileService.generateFile(new CustomType(codeObject.getPackageName(), codeObject.getClassName(), String.format("package %s;\n%s", codeObject.getPackageName(), codeObject.getCode().trim().startsWith("package ") ? codeObject.getCode().substring(codeObject.getCode().indexOf(59) + 1) : codeObject.getCode())), this.overwriteFiles);
    }

    @Override
    public void visit(ServerVariableSpecification specification) {
        log.trace("Generating code for ServerVariableSpecification.");
        ResolvedServerVariableSpecification resolvedSpecification = this.resolver.resolve(specification);
        this.fileService.generateFile(resolvedSpecification, this.overwriteFiles);
        new TypeCodeGeneratorVisitor(this.fileService, this.jsonParser, this.jsonSchemaParser, specification.getTypeName(), resolvedSpecification.getPackageName(), this.overwriteFiles).doVisit(specification.getVariable());
    }

    @Override
    public void visit(WebhookHandleSpecification specification) {
        log.trace("Generating code for WebhookHandleSpecification.");
        ResolvedWebhookHandleSpecification resolvedSpecification = this.resolver.resolve(specification);
        this.fileService.generateFile(resolvedSpecification, this.overwriteFiles);
        ((FunctionPolyType)FunctionPolyType.class.cast(specification.getFunction().getArguments().get(0).getType())).getSpec().getArguments().get(0).accept(new TypeCodeGeneratorVisitor(this.fileService, this.jsonParser, this.jsonSchemaParser, resolvedSpecification.getClassName() + "Event", resolvedSpecification.getPackageName(), this.overwriteFiles));
    }
}

