/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.service.visitor;

import io.polyapi.commons.api.model.PolyEventConsumer;
import io.polyapi.commons.api.websocket.Handle;
import io.polyapi.plugin.model.specification.Specification;
import io.polyapi.plugin.model.specification.function.FunctionSpecification;
import io.polyapi.plugin.model.specification.variable.ServerVariableSpecification;
import io.polyapi.plugin.model.specification.webhook.WebhookHandleSpecification;
import io.polyapi.plugin.model.type.PolyType;
import io.polyapi.plugin.model.type.basic.ArrayPolyType;
import io.polyapi.plugin.model.type.complex.MapObjectPolyType;
import io.polyapi.plugin.model.type.complex.PropertiesObjectPolyType;
import io.polyapi.plugin.model.type.complex.SchemaObjectPolyType;
import io.polyapi.plugin.model.type.function.FunctionPolyType;
import io.polyapi.plugin.model.type.function.FunctionSpecPolyType;
import io.polyapi.plugin.model.visitor.PolySpecificationVisitor;
import io.polyapi.plugin.model.visitor.TypeVisitor;
import io.polyapi.plugin.service.schema.JsonSchemaParser;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportsCollectorVisitor
implements TypeVisitor,
PolySpecificationVisitor {
    private static final Logger log = LoggerFactory.getLogger(ImportsCollectorVisitor.class);
    private final String basePackage;
    private final String defaultType;
    private final Set<String> imports = new HashSet<String>();
    private final JsonSchemaParser jsonSchemaParser;

    public ImportsCollectorVisitor(String basePackage, String defaultType, JsonSchemaParser jsonSchemaParser) {
        this.basePackage = basePackage;
        this.defaultType = defaultType;
        this.jsonSchemaParser = jsonSchemaParser;
    }

    public void doVisit(PolyType type) {
        log.debug("Extracting imports from type {}.", (Object)type.getKind());
        type.accept(this);
        log.debug("Imports from type {} extracted.", (Object)type.getKind());
    }

    @Override
    public void doVisit(Specification specification) {
        log.debug("Extracting imports from {} specification '{}' on context '{}'.", new Object[]{specification.getType(), specification.getName(), specification.getContext()});
        PolySpecificationVisitor.super.doVisit(specification);
        log.debug("Imports from {} specification '{}' on context '{}' extracted.", new Object[]{specification.getType(), specification.getName(), specification.getContext()});
    }

    @Override
    public void visit(SchemaObjectPolyType type) {
        log.trace("Retrieving imports for SchemaObjectPolyType.");
        Optional.of(type).map(SchemaObjectPolyType::getSchema).filter(Predicate.not(String::isBlank)).map(schema -> this.jsonSchemaParser.getType(this.defaultType, this.basePackage, (String)schema));
    }

    @Override
    public void visit(PropertiesObjectPolyType type) {
        log.trace("Retrieving imports for PropertiesObjectPolyType.");
        this.imports.add(String.format("%s.%s", this.basePackage, this.defaultType));
    }

    @Override
    public void visit(FunctionSpecPolyType type) {
        log.trace("Retrieving imports for FunctionSpecPolyType.");
        ImportsCollectorVisitor resultImportsCollectorVisitor = new ImportsCollectorVisitor(this.basePackage, String.format("%sResult", this.defaultType), this.jsonSchemaParser);
        Optional.ofNullable(type.getReturnType()).ifPresent(resultImportsCollectorVisitor::doVisit);
        this.imports.addAll(resultImportsCollectorVisitor.imports);
        IntStream.range(0, type.getArguments().size()).forEach(i -> {
            ImportsCollectorVisitor argumentImportsCollectorVisitor = new ImportsCollectorVisitor(this.basePackage, String.format("%sArg%s", this.defaultType, i), this.jsonSchemaParser);
            type.getArguments().get(i).accept(argumentImportsCollectorVisitor);
            this.imports.addAll(argumentImportsCollectorVisitor.imports);
        });
    }

    @Override
    public void visit(MapObjectPolyType type) {
        log.trace("Retrieving imports for MapObjectPolyType.");
        this.imports.add(Map.class.getName());
    }

    @Override
    public void visit(ArrayPolyType type) {
        log.trace("Retrieving imports for ArrayPolyType.");
        this.imports.add(List.class.getName());
        TypeVisitor.super.visit(type);
    }

    @Override
    public void visit(FunctionSpecification specification) {
        log.trace("Retrieving imports for FunctionSpecification.");
        this.imports.add(String.format("%s.%s", specification.getPackageName(), specification.getClassName()));
        specification.getFunction().accept(this);
    }

    @Override
    public void visit(ServerVariableSpecification specification) {
        log.trace("Retrieving imports for ServerVariableSpecification.");
        this.imports.add(String.format("%s.%s", specification.getPackageName(), specification.getClassName()));
        this.doVisit(specification.getVariable());
    }

    @Override
    public void visit(WebhookHandleSpecification specification) {
        log.trace("Retrieving imports for WebhookHandleSpecification.");
        this.imports.add(Handle.class.getName());
        this.imports.add(Consumer.class.getName());
        this.imports.add(PolyEventConsumer.class.getName());
        this.imports.add(String.format("%s.%s", specification.getPackageName(), specification.getClassName()));
        ((FunctionPolyType)FunctionPolyType.class.cast(specification.getFunction().getArguments().get(0).getType())).getSpec().getArguments().get(0).accept(this);
    }

    public Set<String> getImports() {
        return this.imports;
    }
}

