/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.service.schema;

import com.fasterxml.jackson.databind.JsonNode;
import io.polyapi.plugin.service.schema.PolyFragmentResolver;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.FragmentResolver;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.SchemaStore;

public class PolySchemaStore
extends SchemaStore {
    protected final FragmentResolver fragmentResolver = new PolyFragmentResolver();

    public synchronized Schema create(URI id, String refFragmentPathDelimiters) {
        URI normalizedId = id.normalize();
        if (!this.schemas.containsKey(normalizedId)) {
            URI baseId = this.removeFragment(id).normalize();
            if (!this.schemas.containsKey(baseId)) {
                this.logger.debug("Reading schema: " + baseId);
                JsonNode baseContent = this.contentResolver.resolve(baseId);
                this.schemas.put(baseId, new Schema(baseId, baseContent, null));
            }
            Schema baseSchema = (Schema)this.schemas.get(baseId);
            if (normalizedId.toString().contains("#")) {
                JsonNode childContent = this.fragmentResolver.resolve(baseSchema.getContent(), "#" + id.getFragment(), refFragmentPathDelimiters);
                this.schemas.put(normalizedId, new Schema(normalizedId, childContent, baseSchema));
            }
        }
        return (Schema)this.schemas.get(normalizedId);
    }

    public Schema create(Schema parent, String path, String refFragmentPathDelimiters) {
        URI id;
        String stringId;
        if (!((String)path).equals("#")) {
            path = StringUtils.stripEnd((String)path, (String)"#?&/");
        }
        if (((String)path).contains("#")) {
            URI fragmentURI;
            String pathExcludingFragment = StringUtils.substringBefore((String)path, (String)"#");
            String fragment = StringUtils.substringAfter((String)path, (String)"#");
            try {
                fragmentURI = new URI(null, null, fragment);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid fragment: " + fragment + " in path: " + (String)path);
            }
            path = pathExcludingFragment + "#" + fragmentURI.getRawFragment();
        }
        if ((stringId = (id = parent == null || parent.getId() == null ? URI.create((String)path) : parent.getId().resolve((String)path)).toString()).endsWith("#")) {
            try {
                id = new URI(StringUtils.stripEnd((String)stringId, (String)"#"));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Bad path: " + stringId);
            }
        }
        if (this.selfReferenceWithoutParentFile(parent, (String)path) || StringUtils.substringBefore((String)stringId, (String)"#").isEmpty()) {
            JsonNode parentContent = parent.getGrandParent().getContent();
            if (this.schemas.containsKey(id)) {
                return (Schema)this.schemas.get(id);
            }
            Schema schema = new Schema(id, this.fragmentResolver.resolve(parentContent, (String)path, refFragmentPathDelimiters), parent.getGrandParent());
            this.schemas.put(id, schema);
            return schema;
        }
        return this.create(id, refFragmentPathDelimiters);
    }
}

