/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.service.schema;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.FragmentResolver;
import org.jsonschema2pojo.JsonPointerUtils;

public class PolyFragmentResolver
extends FragmentResolver {
    public JsonNode resolve(JsonNode tree, String path, String refFragmentPathDelimiters) {
        return this.resolve(tree, new ArrayList<String>(Arrays.asList(StringUtils.split((String)path, (String)refFragmentPathDelimiters))));
    }

    private JsonNode resolve(JsonNode tree, List<String> path) {
        if (path.isEmpty()) {
            return tree;
        }
        String part = path.remove(0);
        if (tree.isArray()) {
            try {
                int index = Integer.parseInt(part);
                return this.resolve(tree.get(index), path);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Not a valid array index: " + part);
            }
        }
        String decodedPart = JsonPointerUtils.decodeReferenceToken((String)URLDecoder.decode(part.replace("+", "%2B"), Charset.defaultCharset()));
        if (tree.has(decodedPart)) {
            return this.resolve(tree.get(decodedPart), path);
        }
        throw new IllegalArgumentException("Path not present: " + decodedPart);
    }
}

