/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.service.schema;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import io.polyapi.plugin.error.PolyApiMavenPluginException;
import io.polyapi.plugin.model.ParsedType;
import io.polyapi.plugin.model.generation.CustomType;
import io.polyapi.plugin.service.PolyCodeWriter;
import io.polyapi.plugin.service.PolyGenerationConfig;
import io.polyapi.plugin.service.schema.PolyRuleFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.SchemaGenerator;
import org.jsonschema2pojo.SchemaMapper;
import org.jsonschema2pojo.rules.RuleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaParser {
    private static final Logger log = LoggerFactory.getLogger(JsonSchemaParser.class);

    public List<CustomType> parse(String defaultName, String packageName, String schema) {
        List<CustomType> list;
        JCodeModel codeModel = new JCodeModel();
        log.trace("Generating Java code from JSON schema {}.", (Object)schema);
        new SchemaMapper((RuleFactory)new PolyRuleFactory((GenerationConfig)new PolyGenerationConfig()), new SchemaGenerator()).generate(codeModel, defaultName, packageName, Optional.ofNullable(schema).orElse(""));
        log.debug("Code generated. Writing to string.");
        PolyCodeWriter codeWriter = new PolyCodeWriter();
        try {
            codeModel.build((CodeWriter)codeWriter);
            Map<String, String> result = codeWriter.getClasses();
            if (log.isTraceEnabled()) {
                result.forEach((name, code) -> log.trace("Generated code for {} is: {}", name, code));
            }
            list = result.entrySet().stream().map(entry -> new CustomType(packageName, (String)entry.getKey(), (String)entry.getValue())).toList();
        }
        catch (Throwable throwable) {
            try {
                try {
                    codeWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new PolyApiMavenPluginException(e);
            }
        }
        codeWriter.close();
        return list;
    }

    public ParsedType getType(String defaultName, String packageName, String schema) {
        try {
            return this.getType(new SchemaMapper((RuleFactory)new PolyRuleFactory((GenerationConfig)new PolyGenerationConfig()), new SchemaGenerator()).generate(new JCodeModel(), defaultName, packageName, Optional.ofNullable(schema).orElse("")).boxify());
        }
        catch (IOException e) {
            throw new PolyApiMavenPluginException(e);
        }
    }

    private ParsedType getType(JClass jClass) {
        return new ParsedType(jClass.erasure().fullName(), Optional.ofNullable(jClass.getTypeParameters()).orElseGet(ArrayList::new).stream().map(this::getType).toList());
    }
}

