/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.service.generation;

import io.polyapi.commons.api.http.HttpClient;
import io.polyapi.commons.api.json.JsonParser;
import io.polyapi.plugin.model.generation.Context;
import io.polyapi.plugin.model.generation.ResolvedContext;
import io.polyapi.plugin.model.specification.Specification;
import io.polyapi.plugin.model.specification.function.ClientFunctionSpecification;
import io.polyapi.plugin.model.specification.function.FunctionSpecification;
import io.polyapi.plugin.model.specification.variable.ServerVariableSpecification;
import io.polyapi.plugin.model.specification.webhook.WebhookHandleSpecification;
import io.polyapi.plugin.service.FileService;
import io.polyapi.plugin.service.FileServiceImpl;
import io.polyapi.plugin.service.SpecificationService;
import io.polyapi.plugin.service.SpecificationServiceImpl;
import io.polyapi.plugin.service.generation.PolyGenerationService;
import io.polyapi.plugin.service.generation.PolyObjectResolverService;
import io.polyapi.plugin.service.schema.JsonSchemaParser;
import io.polyapi.plugin.service.visitor.SpecificationCodeGeneratorVisitor;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolyGenerationServiceImpl
implements PolyGenerationService {
    private static final Logger log = LoggerFactory.getLogger(PolyGenerationServiceImpl.class);
    private final FileService fileService;
    private final JsonParser jsonParser;
    private final JsonSchemaParser jsonSchemaParser;
    private final String host;
    private final Integer port;
    private final PolyObjectResolverService polyObjectResolverService;
    private final SpecificationService specificationService;
    private final String apiKey;

    public PolyGenerationServiceImpl(HttpClient httpClient, JsonParser jsonParser, String host, Integer port, String apiKey) {
        this.jsonParser = jsonParser;
        this.host = host;
        this.port = port;
        this.apiKey = apiKey;
        this.jsonSchemaParser = new JsonSchemaParser();
        this.fileService = new FileServiceImpl();
        this.polyObjectResolverService = new PolyObjectResolverService(this.jsonSchemaParser);
        this.specificationService = new SpecificationServiceImpl(httpClient, jsonParser, host, port);
    }

    @Override
    public void generate(List<String> contextFilters, boolean overwrite) {
        List<Specification> specifications = this.specificationService.list(contextFilters);
        HashMap<String, Object> contextModel = new HashMap<String, Object>();
        contextModel.put("clientId", UUID.randomUUID().toString());
        contextModel.put("host", this.host);
        contextModel.put("port", this.port);
        contextModel.put("apiKey", this.apiKey);
        contextModel.put("apiBaseUrl", String.format("%s:%s", this.host, this.port));
        contextModel.put("packageName", "io.polyapi");
        this.fileService.createFileFromTemplate(new File("target/generated-resources/poly.properties"), "poly.properties", contextModel, overwrite);
        this.fileService.createFileWithContent(new File(new File("target/.poly"), "specs.json"), this.jsonParser.toJsonString(specifications), overwrite);
        this.writeContext("Poly", specifications, overwrite, FunctionSpecification.class, WebhookHandleSpecification.class);
        this.writeContext("Vari", specifications, overwrite, ServerVariableSpecification.class);
        log.info("Sources generated correctly.");
    }

    @SafeVarargs
    private void writeContext(String rootName, List<Specification> specifications, boolean overwrite, Class<? extends Specification> ... filter) {
        log.debug("Creating root context.");
        Context rootContext = new Context(null, rootName);
        specifications.stream().filter(specification -> Arrays.stream(filter).anyMatch(clazz -> clazz.isInstance(specification))).filter(specification -> {
            ClientFunctionSpecification clientFunctionSpecification;
            return !(specification instanceof ClientFunctionSpecification && !(clientFunctionSpecification = (ClientFunctionSpecification)specification).isJava());
        }).forEach(specification -> this.createContext(rootContext, Stream.of(specification.getContext().split("\\.")).filter(Predicate.not(String::isEmpty)).toList(), (Specification)specification));
        this.generate(rootContext, overwrite);
    }

    private void generate(Context context, boolean overwrite) {
        SpecificationCodeGeneratorVisitor visitor = new SpecificationCodeGeneratorVisitor(this.fileService, this.polyObjectResolverService, this.jsonParser, this.jsonSchemaParser, overwrite);
        ResolvedContext resolvedContext = this.polyObjectResolverService.resolve(context);
        if (context.getParent() == null) {
            this.fileService.generateFile(resolvedContext, context.getClassName(), overwrite);
        } else {
            this.fileService.generateFile(resolvedContext, overwrite);
        }
        context.getSubcontexts().forEach(subcontext -> this.generate((Context)subcontext, overwrite));
        context.getSpecifications().forEach(visitor::doVisit);
    }

    private Context createContext(Context parent, List<String> contextList, Specification specification) {
        if (contextList.isEmpty()) {
            log.debug("Adding specification to context {}.", (Object)parent.getName());
            parent.getSpecifications().add(specification);
            return parent;
        }
        String contextName = contextList.get(0);
        log.debug("Retrieving context {}.", (Object)contextName);
        return this.createContext(parent.put(new Context(parent, contextName)), contextList.subList(1, contextList.size()), specification);
    }
}

