/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.service;

import com.fasterxml.jackson.databind.type.TypeFactory;
import io.polyapi.commons.api.http.HttpClient;
import io.polyapi.commons.api.json.JsonParser;
import io.polyapi.commons.api.service.PolyApiService;
import io.polyapi.plugin.model.specification.IgnoredSpecification;
import io.polyapi.plugin.model.specification.Specification;
import io.polyapi.plugin.model.specification.function.ClientFunctionSpecification;
import io.polyapi.plugin.service.SpecificationService;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificationServiceImpl
extends PolyApiService
implements SpecificationService {
    private static final Logger log = LoggerFactory.getLogger(SpecificationServiceImpl.class);

    public SpecificationServiceImpl(HttpClient client, JsonParser jsonParser, String host, Integer port) {
        super(client, jsonParser, host, port);
    }

    @Override
    public List<Specification> list(List<String> contextFilters) {
        log.info("Retrieving JSON specifications from PolyAPI for this user.");
        List specifications = (List)this.get("specs", (Type)TypeFactory.defaultInstance().constructCollectionType(List.class, Specification.class));
        log.debug("{} specifications retrieved without filter.", (Object)specifications.size());
        if (log.isDebugEnabled()) {
            log.trace("Retrieved specifications with the following IDs: [{}]", (Object)specifications.stream().map(Specification::getId).collect(Collectors.joining(", ")));
        }
        log.debug("Validating for duplicate context/name pairs and filtering specification contexts.");
        HashMap filteredMap = new HashMap();
        specifications.stream().filter(Predicate.not(IgnoredSpecification.class::isInstance)).filter(specification -> {
            String context = specification.getContext().trim().toLowerCase();
            return contextFilters.isEmpty() || contextFilters.stream().map(String::trim).map(String::toLowerCase).anyMatch(contextFilter -> contextFilter.equalsIgnoreCase(context) || contextFilter.isEmpty() || context.startsWith(String.format("%s.", contextFilter)));
        }).filter(Predicate.not(specification -> {
            ClientFunctionSpecification clientFunctionSpecification;
            return specification instanceof ClientFunctionSpecification && !(clientFunctionSpecification = (ClientFunctionSpecification)specification).getLanguage().equalsIgnoreCase("java");
        })).forEach(specification -> {
            String key = String.format("%s.%s", specification.getContext(), specification.getName()).toLowerCase();
            if (filteredMap.containsKey(key)) {
                log.warn("Skipping {} specification '{}' in context '{}' as it clashes with {} specification with the same name and context.", new Object[]{specification.getType(), specification.getName(), specification.getContext(), ((Specification)filteredMap.get(key)).getType()});
            } else {
                log.debug("Specification key '{}' not repeated (yet).", (Object)key);
                filteredMap.put(key, specification);
            }
        });
        List<Specification> result = filteredMap.values().stream().toList();
        log.info("{} specifications retrieved.", (Object)result.size());
        return result;
    }
}

