/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.service;

import io.polyapi.commons.api.http.HttpClient;
import io.polyapi.commons.api.json.JsonParser;
import io.polyapi.commons.api.service.PolyApiService;
import io.polyapi.plugin.error.function.UnclearFunctionReferenceException;
import io.polyapi.plugin.model.function.PolyFunction;
import io.polyapi.plugin.model.specification.Specification;
import io.polyapi.plugin.service.PolyFunctionService;
import io.polyapi.plugin.service.SpecificationService;
import io.polyapi.plugin.service.SpecificationServiceImpl;
import java.lang.reflect.Type;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolyFunctionServiceImpl
extends PolyApiService
implements PolyFunctionService {
    private static final Logger log = LoggerFactory.getLogger(PolyFunctionServiceImpl.class);
    private final SpecificationService specificationService;

    public PolyFunctionServiceImpl(HttpClient client, JsonParser jsonParser, String host, Integer port) {
        super(client, jsonParser, host, port);
        this.specificationService = new SpecificationServiceImpl(client, jsonParser, host, port);
    }

    @Override
    public PolyFunction deploy(String type, PolyFunction polyFunction) {
        log.info("Deploying {} function '{}' on context '{}'.", new Object[]{type, polyFunction.getName(), polyFunction.getContext()});
        PolyFunction function = (PolyFunction)this.post(String.format("functions/%s", type), polyFunction, (Type)((Object)PolyFunction.class));
        log.info("Deployment of {} function '{}' on context'{}' successful.", new Object[]{type, polyFunction.getName(), polyFunction.getContext()});
        return function;
    }

    @Override
    public void delete(String context, String name) {
        log.info("Deleting function '{}' on context '{}'.", (Object)name, (Object)context);
        List<Specification> specifications = this.specificationService.list(List.of()).stream().filter(spec -> spec.getName().equalsIgnoreCase(name) && spec.getContext().equalsIgnoreCase(context)).toList();
        if (specifications.size() > 1) {
            List<Specification> filteredSpecifications = specifications.stream().filter(function -> function.getName().equals(name) && function.getContext().equals(context)).toList();
            if (filteredSpecifications.isEmpty()) {
                throw new UnclearFunctionReferenceException(this.toReference(context, name), specifications.stream().map(function -> this.toReference(function.getContext(), function.getName())).toList());
            }
            specifications = filteredSpecifications;
        }
        specifications.stream().findAny().ifPresentOrElse(this::delete, () -> log.warn("No function named '{}' on context '{}' has been deleted.", (Object)name, (Object)context));
    }

    @Override
    public void delete(String id) {
        this.specificationService.list(List.of()).stream().filter(specification -> specification.getId().equals(id)).forEach(this::delete);
    }

    private void delete(Specification specification) {
        log.info("Deleting function with ID '{}'.", (Object)specification.getId());
        String relativePath = "";
        switch (specification.getType()) {
            case "apiFunction": 
            case "customFunction": 
            case "serverFunction": {
                relativePath = specification.getType().toLowerCase().replace("function", "");
                break;
            }
            case "authFunction": {
                relativePath = "auth-providers";
                break;
            }
            case "webhookHandle": {
                relativePath = "webhooks";
                break;
            }
            case "serverVariable": {
                relativePath = "variables";
            }
        }
        super.delete(String.format("functions/%s/%s", relativePath, specification.getId()));
        log.info("Function with ID '{}'.", (Object)specification.getId());
    }

    private String toReference(String context, String name) {
        return String.format("%s.%s", context, name);
    }
}

