/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.service;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JPackage;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolyCodeWriter
extends CodeWriter
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(PolyCodeWriter.class);
    private final Map<String, ByteArrayOutputStream> outputStreams = new HashMap<String, ByteArrayOutputStream>();

    public OutputStream openBinary(JPackage pkg, String fileName) throws IOException {
        log.debug("Opening binary on package {} for file {}", (Object)pkg.name(), (Object)fileName);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.outputStreams.put(fileName.replace(".java", ""), outputStream);
        return new FilterOutputStream(outputStream){

            @Override
            public void close() {
            }
        };
    }

    public Map<String, String> getClasses() {
        return this.outputStreams.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ByteArrayOutputStream)entry.getValue()).toString(Charset.defaultCharset())));
    }

    @Override
    public void close() throws IOException {
        for (OutputStream outputStream : this.outputStreams.values()) {
            outputStream.close();
        }
    }
}

