/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.service;

import io.polyapi.commons.api.model.PolyClientFunction;
import io.polyapi.commons.api.model.PolyFunctionAnnotationRecord;
import io.polyapi.commons.api.model.PolyGeneratedClass;
import io.polyapi.commons.api.model.PolyServerFunction;
import io.polyapi.commons.api.model.RequiredDependencies;
import io.polyapi.commons.api.model.RequiredDependency;
import io.polyapi.plugin.error.validation.PropertyNotFoundException;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.SourceVersion;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenService {
    private static final Logger log = LoggerFactory.getLogger(MavenService.class);
    private static final String FUNCTION_NAME_PATTERN = "^[a-z][\\w$]*$";
    private static final String CONTEXT_PATTERN = "^[a-z][\\w$.]*[\\w$]$";
    private final MavenProject project;

    public MavenService(MavenProject project) {
        this.project = project;
    }

    public void getPropertyFromPlugin(String propertyName, String currentValue, Consumer<String> callback) {
        log.debug("Checking value of '{}' as an input parameter.", (Object)propertyName);
        if (currentValue == null) {
            log.debug("Parameter '{}' is empty. Attempting to retrieve it from plugin configuration.", (Object)propertyName);
            callback.andThen(value -> log.debug("Parameter '{}' value is '{}'.", (Object)propertyName, value)).accept(this.getPropertyFromPlugin("io.polyapi.client", "library", propertyName));
        } else {
            log.debug("Parameter '{}' value is '{}'", (Object)propertyName, (Object)currentValue);
        }
    }

    public String getPropertyFromPlugin(String pluginGroupId, String pluginArtifactId, String propertyName) {
        log.debug("Scanning plugins.");
        List plugins = Optional.ofNullable(this.project).map(MavenProject::getBuild).map(PluginContainer::getPlugins).orElseGet(ArrayList::new);
        log.debug("Found {} plugins. Filtering by group ID matching '{}' and artifact ID matching '{}'.", new Object[]{plugins.size(), pluginGroupId, pluginArtifactId});
        return plugins.stream().filter(plugin -> pluginGroupId.equals(plugin.getGroupId())).filter(plugin -> pluginArtifactId.equals(plugin.getArtifactId())).flatMap(plugin -> {
            log.debug("Found match: {}.{}:{}.\nRetrieving executions.", new Object[]{plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion()});
            List executions = Optional.ofNullable(plugin.getExecutions()).orElseGet(ArrayList::new);
            log.debug("Found {} executions.", (Object)executions.size());
            return executions.stream();
        }).map(ConfigurationContainer::getConfiguration).filter(Objects::nonNull).map(Xpp3Dom.class::cast).flatMap(configuration -> {
            log.debug("Found configuration within the execution. Retrieving children.");
            Xpp3Dom[] children = Optional.ofNullable(configuration.getChildren()).orElse(new Xpp3Dom[0]);
            log.debug("Found {} children properties.", (Object)children.length);
            return Arrays.stream(children);
        }).map(Xpp3Dom::getValue).findFirst().orElseThrow(() -> new PropertyNotFoundException(propertyName));
    }

    public URLClassLoader getProjectClassLoader() {
        try {
            return new URLClassLoader((URL[])Stream.concat(Stream.concat(this.project.getCompileClasspathElements().stream(), this.project.getRuntimeClasspathElements().stream()), Stream.of(this.project.getBuild().getOutputDirectory())).map(File::new).filter(File::exists).map(File::toURI).map(uri -> {
                try {
                    return uri.toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(URL[]::new), MavenService.class.getClassLoader());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<Method> scanPolyFunctions(Predicate<Method> filter) {
        log.info("Scanning the project for functions annotated with {} or {}.", (Object)PolyServerFunction.class.getName(), (Object)PolyClientFunction.class.getName());
        URLClassLoader projectClassLoader = this.getProjectClassLoader();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addClassLoaders(new ClassLoader[]{projectClassLoader}).addScanners(new Scanner[]{Scanners.MethodsAnnotated}).addUrls(projectClassLoader.getURLs()));
        log.info("Reflections URLS: {}", (Object)reflections.getConfiguration().getUrls().size());
        Set methods = Stream.concat(reflections.getMethodsAnnotatedWith(PolyServerFunction.class).stream(), reflections.getMethodsAnnotatedWith(PolyClientFunction.class).stream()).filter(filter).filter(Predicate.not(method -> method.getDeclaringClass().isAnnotationPresent(PolyGeneratedClass.class))).collect(Collectors.toSet());
        log.info("Found {} methods to convert.", (Object)methods.size());
        List.of(RequiredDependency.class, RequiredDependencies.class).forEach(annotation -> reflections.getMethodsAnnotatedWith(annotation).stream().filter(Predicate.not(methods::contains)).forEach(misusedMethod -> log.warn("Method {} is annotated with {} but is ignored as it needs to be annotated with either {} or {} to be scanned.", new Object[]{misusedMethod, misusedMethod.getAnnotation(annotation).getClass().getSimpleName(), PolyServerFunction.class.getSimpleName(), PolyClientFunction.class.getSimpleName()})));
        Set<Method> validatedMethods = methods.stream().filter(method -> {
            boolean result = true;
            PolyFunctionAnnotationRecord polyFunction = PolyFunctionAnnotationRecord.createFrom((Method)method);
            log.debug("Validating function name.");
            String functionName = Optional.ofNullable(polyFunction.name()).filter(Predicate.not(String::isBlank)).orElseGet(method::getName);
            if (!functionName.matches(FUNCTION_NAME_PATTERN)) {
                log.error("Method '{}' skipped. Property 'functionName' with value '{}' doesn't match pattern '{}'.", new Object[]{method, functionName, FUNCTION_NAME_PATTERN});
                result = false;
            }
            if (SourceVersion.isKeyword(functionName.trim())) {
                log.error("Method '{}' skipped. Property 'functionName' with value '{}' is a Java keyword.", method, (Object)functionName);
                result = false;
            }
            return result;
        }).filter(method -> {
            String keywords;
            boolean result = true;
            PolyFunctionAnnotationRecord polyFunction = PolyFunctionAnnotationRecord.createFrom((Method)method);
            log.debug("Validating context.");
            String context = Optional.ofNullable(polyFunction.context()).filter(Predicate.not(String::isEmpty)).orElseGet(method.getDeclaringClass()::getPackageName);
            if (!context.matches(CONTEXT_PATTERN)) {
                log.error("Method '{}' skipped. Property 'context' with value '{}' doesn't match pattern '{}'.", new Object[]{method, context, CONTEXT_PATTERN});
                result = false;
            }
            if (!(keywords = Arrays.stream(context.split("\\.")).filter(SourceVersion::isKeyword).collect(Collectors.joining(","))).isEmpty()) {
                log.error("Method '{}' skipped. Property 'context' with value '{}' uses Java keywords '{}}'. Please rename the context accordingly.", new Object[]{method, context, keywords});
                result = false;
            }
            return result;
        }).filter(method -> {
            PolyFunctionAnnotationRecord polyFunction = PolyFunctionAnnotationRecord.createFrom((Method)method);
            boolean isDeployable = polyFunction.deployFunction();
            if (!isDeployable) {
                log.warn("Method '{}' skipped. Marked as not deployable.", method);
            }
            return isDeployable;
        }).collect(Collectors.toSet());
        if (validatedMethods.size() < methods.size()) {
            log.warn("Only {} of {} methods are valid.", (Object)validatedMethods.size(), (Object)methods.size());
        }
        return validatedMethods;
    }

    public List<String> getMatchingDependencies(List<String> patterns) {
        log.debug("Retrieving required dependencies.");
        Pattern pattern = Pattern.compile(Optional.of(String.join((CharSequence)"|", patterns)).filter(Predicate.not(String::isEmpty)).orElse("(?=a)b"));
        log.debug("Pattern used to match required dependencies is: {}", (Object)pattern.pattern());
        List<String> requiredDependencies = this.project.getDependencies().stream().map(dependency -> String.format("%s:%s:%s", dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion())).filter(pattern.asPredicate()).toList();
        log.debug("Required dependencies found: {}", requiredDependencies);
        return requiredDependencies;
    }
}

