/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.service;

import com.github.jknack.handlebars.Handlebars;
import io.polyapi.commons.api.error.PolyApiException;
import io.polyapi.plugin.service.FileService;
import io.polyapi.plugin.service.template.PolyHandlebars;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileServiceImpl
implements FileService {
    private static final Logger log = LoggerFactory.getLogger(FileServiceImpl.class);
    private final Handlebars handlebars = new PolyHandlebars();

    @Override
    public void createFileFromTemplate(File file, String template, Object context, boolean overwriteFiles) {
        try {
            log.debug("Creating file content using template {}.", (Object)template);
            String content = this.handlebars.compile(template).apply(context);
            log.trace("Content created:\n{}", (Object)content);
            this.createFileWithContent(file, content, overwriteFiles);
        }
        catch (IOException e) {
            throw new PolyApiException(String.format("An exception occurred while creating content for template %s.", template), (Throwable)e);
        }
    }

    @Override
    public void createFileWithContent(File file, String content, boolean overwriteFiles) {
        if (file.exists() && !overwriteFiles) {
            log.debug("File {} already exists. Skipping its creation.", (Object)file.getAbsolutePath());
        } else {
            log.debug("Creating file with content for file {}.", (Object)file.getAbsolutePath());
            File parent = file.getParentFile();
            log.debug("Creating parent folder at {}.", (Object)parent.getAbsolutePath());
            parent.mkdirs();
            try (PrintWriter out = new PrintWriter(file);){
                out.println(content);
            }
            catch (FileNotFoundException e) {
                throw new PolyApiException(String.format("An exception occurred while creating file %s.", file.getAbsolutePath()), (Throwable)e);
            }
            finally {
                log.debug("File {} created successfully.", (Object)file.getAbsolutePath());
            }
        }
    }
}

