/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.service;

import com.fasterxml.jackson.databind.type.TypeFactory;
import io.polyapi.commons.api.error.http.HttpResponseException;
import io.polyapi.commons.api.http.HttpClient;
import io.polyapi.commons.api.json.JsonParser;
import io.polyapi.commons.api.model.PolyFunctionAnnotationRecord;
import io.polyapi.commons.api.model.RequiredDependencies;
import io.polyapi.commons.api.model.RequiredDependency;
import io.polyapi.plugin.error.PolyApiMavenPluginException;
import io.polyapi.plugin.error.deploy.DeploymentWrapperException;
import io.polyapi.plugin.model.function.CodeObject;
import io.polyapi.plugin.model.function.PolyFunction;
import io.polyapi.plugin.model.function.PolyFunctionArgument;
import io.polyapi.plugin.service.DeploymentService;
import io.polyapi.plugin.service.MavenService;
import io.polyapi.plugin.service.PolyFunctionServiceImpl;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentServiceImpl
implements DeploymentService {
    private static final Logger log = LoggerFactory.getLogger(DeploymentServiceImpl.class);
    private final HttpClient httpClient;
    private final JsonParser jsonParser;
    private final MavenService mavenService;
    private final String host;
    private final Integer port;

    @Override
    public List<PolyFunction> deployFunctions(List<String> functionFilters, boolean dryRun) {
        Predicate<Method> filter;
        PolyFunctionServiceImpl polyFunctionService = new PolyFunctionServiceImpl(this.httpClient, this.jsonParser, this.host, this.port);
        HashMap exceptions = new HashMap();
        if (functionFilters.isEmpty()) {
            log.debug("No specific functions to deploy were declared.");
            filter = method -> true;
        } else {
            filter = method -> functionFilters.stream().anyMatch(name -> {
                PolyFunctionAnnotationRecord annotation = PolyFunctionAnnotationRecord.createFrom((Method)method);
                String functionName = Optional.ofNullable(annotation).map(PolyFunctionAnnotationRecord::name).filter(Predicate.not(String::isBlank)).orElseGet(method::getName);
                if (functionName.equals(name)) return true;
                Object[] objectArray = new Object[2];
                objectArray[0] = Optional.ofNullable(annotation).map(PolyFunctionAnnotationRecord::context).filter(Predicate.not(String::isBlank)).orElseGet(method.getDeclaringClass()::getPackageName);
                objectArray[1] = functionName;
                if (!String.format("%s.%s", objectArray).equals(name)) return false;
                return true;
            });
        }
        Set<Method> methods = this.mavenService.scanPolyFunctions(filter);
        List<PolyFunction> deployedFunctions = methods.stream().map(method -> {
            log.info("Processing method '{}'.", method);
            PolyFunctionAnnotationRecord annotation = PolyFunctionAnnotationRecord.createFrom((Method)method);
            Class<?> declaringClass = method.getDeclaringClass();
            PolyFunction polyFunction = new PolyFunction();
            polyFunction.setName(Optional.ofNullable(annotation.name()).filter(Predicate.not(String::isBlank)).orElseGet(method::getName));
            log.debug("Poly function name is '{}'.", (Object)polyFunction.getName());
            polyFunction.setLanguage("java");
            CodeObject codeObject = new CodeObject();
            codeObject.setClassName(declaringClass.getSimpleName());
            codeObject.setPackageName(declaringClass.getPackageName());
            codeObject.setMethodName(method.getName());
            codeObject.setParams(Arrays.stream(method.getParameters()).map(Parameter::getType).map(Class::getName).collect(Collectors.joining(",")));
            String sourceCodePath = String.format("src/main/java/%s/%s.java", declaringClass.getPackageName().replace(".", "/"), declaringClass.getSimpleName());
            log.debug("Obtaining source code from '{}'", (Object)sourceCodePath);
            try (FileInputStream fileInputStream = new FileInputStream(sourceCodePath);){
                String code = IOUtils.toString((InputStream)fileInputStream, (Charset)Charset.defaultCharset());
                codeObject.setCode(code);
                if (annotation.contextAwareness().equals("-autodetect-")) {
                    Set matches = Pattern.compile("(Vari|Poly)\\.[.a-zA-Z0-9_\\s]+[^.a-zA-Z0-9_\\s]").matcher(code).results().map(MatchResult::group).flatMap(result -> {
                        log.debug("Processing match {}", result);
                        List<String> parts = Arrays.stream(result.substring(5).replace("\n", "").split("\\.")).toList();
                        List<String> usedParts = parts.size() > 1 ? parts.subList(0, parts.size() - 1) : List.of("");
                        log.trace("Context parts: {}", usedParts);
                        return IntStream.range(0, usedParts.size()).boxed().map(i -> String.join((CharSequence)".", usedParts.subList(0, i + 1)));
                    }).collect(Collectors.toSet());
                    codeObject.setAvailableContexts(matches.isEmpty() ? "-" : String.join((CharSequence)",", matches));
                    if (dryRun) {
                        log.info("Auto-detected contexts: {}", (Object)codeObject.getAvailableContexts());
                    } else {
                        log.debug("Auto-detected contexts: {}", (Object)codeObject.getAvailableContexts());
                    }
                } else {
                    codeObject.setAvailableContexts(annotation.contextAwareness());
                }
            }
            catch (IOException e) {
                throw new PolyApiMavenPluginException(e);
            }
            polyFunction.setCode(this.jsonParser.toJsonString((Object)codeObject));
            polyFunction.setContext(Optional.ofNullable(annotation.context()).filter(Predicate.not(String::isBlank)).orElseGet(declaringClass::getPackageName));
            log.debug("Poly function context is '{}'", (Object)polyFunction.getContext());
            log.debug("Processing parameters.");
            polyFunction.setArguments(new ArrayList<PolyFunctionArgument>());
            Arrays.stream(method.getParameters()).map(parameter -> {
                log.debug("Processing parameter {}", parameter);
                PolyFunctionArgument argument = new PolyFunctionArgument();
                if (parameter.getType().equals(Object.class)) {
                    argument.setType("any");
                } else {
                    argument.setType(parameter.getParameterizedType().getTypeName());
                    argument.setTypeSchema(this.jsonParser.toJsonSchema(parameter.getParameterizedType()));
                }
                argument.setRequired(true);
                argument.setKey(parameter.getName());
                argument.setName(parameter.getName());
                log.debug("Parameter '{}' of type '{}' processed.", (Object)parameter.getName(), (Object)parameter.getParameterizedType());
                return argument;
            }).forEach(polyFunction.getArguments()::add);
            log.debug("Retrieving required dependencies.");
            polyFunction.setRequirements(this.mavenService.getMatchingDependencies(Stream.concat(Optional.ofNullable(method.getAnnotation(RequiredDependencies.class)).map(RequiredDependencies::value).stream().flatMap(Arrays::stream), Optional.ofNullable(method.getAnnotation(RequiredDependency.class)).stream()).map(requiredDependency -> String.format("%s:%s:%s", requiredDependency.groupId(), requiredDependency.artifactId(), requiredDependency.version())).toList()));
            polyFunction.setReturnType(switch (method.getReturnType().getTypeName()) {
                case "java.lang.Integer", "java.lang.Long", "java.lang.Number", "java.lang.Double", "java.lang.Float", "java.lang.Short", "java.lang.Byte" -> "number";
                case "java.lang.Boolean" -> "boolean";
                case "java.lang.String", "java.lang.Character" -> "string";
                case "java.lang.Object" -> "any";
                case "void" -> "void";
                default -> "object";
            });
            if (!polyFunction.getReturnType().equals("any") && !polyFunction.getReturnType().equals("void")) {
                Optional.of(method.getGenericReturnType()).map(arg_0 -> ((JsonParser)this.jsonParser).toJsonSchema(arg_0)).map(schema -> (Map)this.jsonParser.parseString(schema, (Type)TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, Object.class))).ifPresent(polyFunction::setReturnTypeSchema);
            }
            String type = annotation.type();
            PolyFunction result2 = null;
            if (dryRun) {
                log.debug("{} function with content '{}' should be deployed.", (Object)type, (Object)polyFunction);
                log.info("Skipping deployment of {} function '{}' because dry run mode is activated.", (Object)type, (Object)polyFunction.getName());
            } else {
                try {
                    result2 = polyFunctionService.deploy(type, polyFunction);
                }
                catch (HttpResponseException e) {
                    log.error("{} function '{}' deployment failed.", (Object)type, (Object)polyFunction.getName());
                    exceptions.put(polyFunction, e);
                }
            }
            return result2;
        }).filter(Objects::nonNull).toList();
        if (!exceptions.isEmpty()) {
            throw new DeploymentWrapperException(exceptions.values());
        }
        log.info("Deployment of {} functions complete.", (Object)methods.size());
        return deployedFunctions;
    }

    public DeploymentServiceImpl(HttpClient httpClient, JsonParser jsonParser, MavenService mavenService, String host, Integer port) {
        this.httpClient = httpClient;
        this.jsonParser = jsonParser;
        this.mavenService = mavenService;
        this.host = host;
        this.port = port;
    }
}

