/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.mojo.validation;

import io.polyapi.plugin.error.validation.InexistentFileException;
import io.polyapi.plugin.error.validation.InvalidPortNumberException;
import io.polyapi.plugin.error.validation.InvalidUUIDException;
import io.polyapi.plugin.error.validation.NullOrEmptyValueException;
import java.io.File;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator {
    private static final Logger log = LoggerFactory.getLogger(Validator.class);

    public static void validateNotEmpty(String propertyName, String object) {
        log.debug("Validating that property '{}' is not null nor empty.", (Object)propertyName);
        Optional.ofNullable(object).map(String::trim).filter(Predicate.not(String::isEmpty)).orElseThrow(() -> new NullOrEmptyValueException(propertyName));
        log.trace("Property '{}' value is '{}'.", (Object)propertyName, (Object)object);
    }

    public static void validateFileExistence(String propertyName, File file) {
        log.debug("Validating that property '{}' exists as a file.", (Object)propertyName);
        Optional.ofNullable(file).filter(File::exists).orElseThrow(() -> new InexistentFileException(propertyName, file));
        log.trace("Property '{}' exists as a file in path {}.", (Object)propertyName, (Object)file.getAbsolutePath());
    }

    public static void validatePortFormat(String propertyName, String property) {
        log.debug("Validating that property '{}' has a valid port format.", (Object)propertyName);
        Validator.validateNotEmpty(propertyName, property);
        try {
            Integer value = Integer.valueOf(property);
            if (value > 65535 || value < 0) {
                throw new InvalidPortNumberException(propertyName, property);
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidPortNumberException(propertyName, property, e);
        }
    }

    public static void validateUUIDFormat(String propertyName, String property) {
        try {
            log.debug("Validating that property '{}' has a valid key format.", (Object)propertyName);
            Validator.validateNotEmpty(propertyName, property);
            UUID.fromString(property);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidUUIDException(propertyName, property, e);
        }
    }
}

