/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.mojo;

import io.polyapi.commons.api.error.http.HttpResponseException;
import io.polyapi.commons.api.error.http.UnexpectedHttpResponseException;
import io.polyapi.commons.api.http.HttpClient;
import io.polyapi.commons.api.http.TokenProvider;
import io.polyapi.commons.api.json.JsonParser;
import io.polyapi.commons.internal.http.DefaultHttpClient;
import io.polyapi.commons.internal.http.HardcodedTokenProvider;
import io.polyapi.commons.internal.http.HttpClientConfiguration;
import io.polyapi.commons.internal.json.JacksonJsonParser;
import io.polyapi.plugin.error.PolyApiMavenPluginException;
import io.polyapi.plugin.mojo.validation.Validator;
import io.polyapi.plugin.service.MavenService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PolyApiMojo
extends AbstractMojo {
    private static final Logger log = LoggerFactory.getLogger(PolyApiMojo.class);
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="host", required=true)
    private String host;
    @Parameter(property="port")
    private String port;
    @Parameter(property="apiKey", required=true)
    private String apiKey;
    private MavenService mavenService;
    private TokenProvider tokenProvider;
    private HttpClient httpClient;
    private JsonParser jsonParser;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            log.debug("Setting up Maven service.");
            this.mavenService = new MavenService(this.project);
            this.mavenService.getPropertyFromPlugin("host", this.host, this::setHost);
            this.mavenService.getPropertyFromPlugin("port", this.port, this::setPort);
            Validator.validatePortFormat("port", this.port);
            this.mavenService.getPropertyFromPlugin("apiKey", this.apiKey, this::setApiKey);
            Validator.validateNotEmpty("apiKey", this.apiKey);
            this.tokenProvider = new HardcodedTokenProvider(this.apiKey);
            this.httpClient = new DefaultHttpClient(HttpClientConfiguration.builder((TokenProvider)this.tokenProvider).build());
            this.jsonParser = new JacksonJsonParser();
            log.debug("Using host: {}", (Object)this.host);
            log.debug("Using port: {}", (Object)this.host);
            this.execute(this.host, Integer.valueOf(this.port));
        }
        catch (PolyApiMavenPluginException e) {
            log.error("An exception occurred during the plugin execution.", (Throwable)((Object)e));
            List<Throwable> suppressedExceptions = Arrays.stream(Optional.ofNullable(e.getSuppressed()).orElse(new Throwable[0])).toList();
            for (Throwable suppressedException : suppressedExceptions) {
                try {
                    if (suppressedException instanceof HttpResponseException) {
                        HttpResponseException httpException = (HttpResponseException)suppressedException;
                        log.debug(IOUtils.toString((InputStream)httpException.getResponse().body(), (Charset)Charset.defaultCharset()));
                        continue;
                    }
                    log.error("Non HTTP suppressed exception: {}", (Object)suppressedException.getMessage());
                }
                catch (IOException ex) {
                    throw new MojoExecutionException((Throwable)ex);
                }
            }
            throw new MojoFailureException((Throwable)((Object)e));
        }
        catch (UnexpectedHttpResponseException e) {
            log.error("An unexpected HTTP response code {} was returned from the server.", (Object)e.getResponse().statusCode());
            if (log.isDebugEnabled()) {
                try {
                    log.debug("Response from server is: {}", (Object)IOUtils.toString((InputStream)e.getResponse().body(), (Charset)Charset.defaultCharset()));
                }
                catch (IOException ex) {
                    throw new MojoExecutionException((Throwable)ex);
                }
            }
            throw new MojoFailureException((Throwable)e);
        }
        catch (RuntimeException e) {
            log.error("An unexpected exception occurred during the plugin execution.", (Throwable)e);
            throw new MojoExecutionException((Throwable)e);
        }
    }

    protected MavenService getMavenService() {
        return this.mavenService;
    }

    protected TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected JsonParser getJsonParser() {
        return this.jsonParser;
    }

    protected abstract void execute(String var1, Integer var2);

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setMavenService(MavenService mavenService) {
        this.mavenService = mavenService;
    }

    public void setTokenProvider(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setJsonParser(JsonParser jsonParser) {
        this.jsonParser = jsonParser;
    }
}

