/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.mojo;

import io.polyapi.plugin.mojo.PolyApiMojo;
import io.polyapi.plugin.service.generation.PolyGenerationService;
import io.polyapi.plugin.service.generation.PolyGenerationServiceImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="generate-sources")
public class GenerateSourcesMojo
extends PolyApiMojo {
    private static final Logger log = LoggerFactory.getLogger(GenerateSourcesMojo.class);
    @Parameter(property="overwrite", defaultValue="false")
    private Boolean overwrite;
    @Parameter(property="context")
    private String context;
    private PolyGenerationService polyGenerationService;

    @Override
    public void execute(String host, Integer port) {
        log.info("Initiating generation of Poly sources.");
        this.polyGenerationService = new PolyGenerationServiceImpl(this.getHttpClient(), this.getJsonParser(), host, port, this.getTokenProvider().getToken());
        List<String> contextFilters = Arrays.stream(Optional.ofNullable(this.context).map(contextCsv -> contextCsv.split(",")).orElse(new String[]{""})).toList();
        log.debug("Context filters: \"{}\"", (Object)String.join((CharSequence)"\", \"", contextFilters));
        this.polyGenerationService.generate(contextFilters, this.overwrite);
        log.info("Poly generation complete.");
    }

    public void setOverwrite(Boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setPolyGenerationService(PolyGenerationService polyGenerationService) {
        this.polyGenerationService = polyGenerationService;
    }
}

