/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.mojo;

import com.google.common.base.Predicates;
import io.polyapi.plugin.model.function.PolyFunction;
import io.polyapi.plugin.mojo.PolyApiMojo;
import io.polyapi.plugin.service.DeploymentServiceImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="deploy-functions", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DeployFunctionsMojo
extends PolyApiMojo {
    private static final Logger log = LoggerFactory.getLogger(DeployFunctionsMojo.class);
    @Parameter(property="functions")
    private String functions;
    @Parameter(property="dry-run", defaultValue="false")
    private boolean dryRun;

    @Override
    protected void execute(String host, Integer port) {
        log.info("Initiating deployment of Poly functions.");
        DeploymentServiceImpl polyFunctionService = new DeploymentServiceImpl(this.getHttpClient(), this.getJsonParser(), this.getMavenService(), host, port);
        List<String> functionFilters = Arrays.stream(Optional.ofNullable(this.functions).orElse("").split(",")).map(String::trim).filter(Predicate.not(Predicates.equalTo((Object)""))).toList();
        log.debug("Function filters: \"{}\"", (Object)String.join((CharSequence)"\", \"", functionFilters));
        if (this.dryRun) {
            log.warn("Dry run mode is set. This won't deploy to server.");
        }
        List<PolyFunction> deployedFunctions = polyFunctionService.deployFunctions(functionFilters, this.dryRun);
        log.info("Deployed {} functions:", (Object)deployedFunctions.size());
        deployedFunctions.forEach(deployedFunction -> log.info("    - Deployed function '{}' on context '{}' with id '{}'", new Object[]{deployedFunction.getSignature(), deployedFunction.getContext(), deployedFunction.getId()}));
        log.info("Poly functions deployment complete.");
    }

    public void setFunctions(String functions) {
        this.functions = functions;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }
}

