/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.mojo;

import io.polyapi.plugin.error.validation.BadExclusionException;
import io.polyapi.plugin.mojo.PolyApiMojo;
import io.polyapi.plugin.mojo.validation.Validator;
import io.polyapi.plugin.service.PolyFunctionServiceImpl;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="delete-function", requiresProject=false)
public class DeleteFunctionMojo
extends PolyApiMojo {
    private static final Logger log = LoggerFactory.getLogger(DeleteFunctionMojo.class);
    @Parameter(property="functionName")
    private String functionName;
    @Parameter(property="context")
    private String context;
    @Parameter(property="id")
    private String id;

    @Override
    protected void execute(String host, Integer port) {
        log.info("Initiating deletion of Poly function.");
        PolyFunctionServiceImpl service = new PolyFunctionServiceImpl(this.getHttpClient(), this.getJsonParser(), host, port);
        Optional.ofNullable(this.id).ifPresentOrElse(functionId -> {
            if (StringUtils.isNotBlank((String)this.functionName)) {
                throw new BadExclusionException("id", "functionName");
            }
            if (StringUtils.isNotBlank((String)this.context)) {
                throw new BadExclusionException("id", "context");
            }
            Validator.validateUUIDFormat("id", functionId);
            service.delete((String)functionId);
        }, () -> {
            Validator.validateNotEmpty("functionName", this.functionName);
            Validator.validateNotEmpty("context", this.context);
            service.delete(this.context, this.functionName);
        });
        log.info("Poly function deletion complete.");
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setId(String id) {
        this.id = id;
    }
}

