/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.mojo;

import io.polyapi.plugin.model.ServerVariable;
import io.polyapi.plugin.mojo.PolyApiMojo;
import io.polyapi.plugin.service.ServerVariableServiceImpl;
import java.util.Optional;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="create-server-variable", requiresProject=false)
public class CreateServerVariableMojo
extends PolyApiMojo {
    private static final Logger log = LoggerFactory.getLogger(CreateServerVariableMojo.class);
    @Parameter(property="name", required=true)
    private String name;
    @Parameter(property="context", required=true)
    private String context;
    @Parameter(property="description")
    private String description;
    @Parameter(property="type")
    private String type;
    @Parameter(property="value", required=true)
    private String value;
    @Parameter(property="secret", defaultValue="true")
    private boolean secret;

    @Override
    protected void execute(String host, Integer port) {
        log.info("Initiating creation of server variable.");
        ServerVariableServiceImpl serverVariableService = new ServerVariableServiceImpl(this.getHttpClient(), this.getJsonParser(), host, port);
        Object usedValue = switch (Optional.ofNullable(this.type).orElse("").toLowerCase()) {
            case "string", "java.lang.string" -> this.value;
            case "byte", "java.lang.byte", "short", "java.lang.short", "integer", "java.lang.integer", "long", "java.lang.long" -> Long.valueOf(this.value);
            case "float", "java.lang.float", "double", "java.lang.double" -> Double.valueOf(this.value);
            case "boolean", "java.lang.boolean" -> Boolean.valueOf(this.value);
            default -> {
                if (this.value.equalsIgnoreCase(Boolean.TRUE.toString()) || this.value.equalsIgnoreCase(Boolean.FALSE.toString())) {
                    yield Boolean.valueOf(this.value);
                }
                if (NumberUtils.isParsable((String)this.value)) {
                    Double doubleValue = Double.valueOf(this.value);
                    if (doubleValue - (double)doubleValue.longValue() == 0.0) {
                        yield doubleValue.longValue();
                    }
                    yield doubleValue;
                }
                yield this.value;
            }
        };
        log.debug("Used type '{}'", (Object)this.value.getClass().getName());
        ServerVariable serverVariable = serverVariableService.create(this.name, this.description, usedValue, this.secret, this.context);
        log.info("Server variable '{}' created with ID '{}'.", (Object)serverVariable.getName(), (Object)serverVariable.getId());
        log.info("Server variable creation complete.");
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setSecret(boolean secret) {
        this.secret = secret;
    }
}

