/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.model.visitor;

import io.polyapi.plugin.model.specification.variable.VariablePolyType;
import io.polyapi.plugin.model.type.PolyType;
import io.polyapi.plugin.model.type.PropertyPolyType;
import io.polyapi.plugin.model.type.basic.AnyPolyType;
import io.polyapi.plugin.model.type.basic.ArrayPolyType;
import io.polyapi.plugin.model.type.basic.PlainPolyType;
import io.polyapi.plugin.model.type.basic.VoidPolyType;
import io.polyapi.plugin.model.type.complex.MapObjectPolyType;
import io.polyapi.plugin.model.type.complex.ObjectPolyType;
import io.polyapi.plugin.model.type.complex.PropertiesObjectPolyType;
import io.polyapi.plugin.model.type.complex.SchemaObjectPolyType;
import io.polyapi.plugin.model.type.function.FunctionPolyType;
import io.polyapi.plugin.model.type.function.FunctionSpecPolyType;
import io.polyapi.plugin.model.type.primitive.PrimitivePolyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface TypeVisitor {
    public static final Logger log = LoggerFactory.getLogger(TypeVisitor.class);

    default public void visit(PolyType polyType) {
        log.trace("Visiting PolyType.");
    }

    default public void visit(ObjectPolyType type) {
        log.trace("Visiting ObjectPolyType.");
        this.visit((PolyType)type);
    }

    default public void visit(SchemaObjectPolyType type) {
        log.trace("Visiting SchemaObjectPolyType.");
        this.visit((ObjectPolyType)type);
    }

    default public void visit(PropertiesObjectPolyType type) {
        log.trace("Visiting PropertiesObjectPolyType.");
        this.visit((ObjectPolyType)type);
    }

    default public void visit(MapObjectPolyType type) {
        log.trace("Visiting MapObjectPolyType.");
        this.visit((ObjectPolyType)type);
    }

    default public void visit(PlainPolyType type) {
        log.trace("Visiting PlainPolyType.");
        this.visit((PolyType)type);
    }

    default public void visit(VoidPolyType type) {
        log.trace("Visiting VoidPolyType.");
        this.visit((PolyType)type);
    }

    default public void visit(ArrayPolyType type) {
        log.trace("Visiting ArrayPolyType.");
        type.getItems().accept(this);
    }

    default public void visit(FunctionSpecPolyType type) {
        log.trace("Visiting FunctionSpecPolyType.");
        type.getArguments().forEach(argument -> argument.accept(this));
        type.getReturnType().accept(this);
    }

    default public void visit(VariablePolyType type) {
        log.trace("Visiting VariablePolyType.");
        type.getValueType().accept(this);
    }

    default public void visit(FunctionPolyType type) {
        log.trace("Visiting FunctionPolyType.");
        type.getSpec().accept(this);
    }

    default public void visit(PropertyPolyType type) {
        log.trace("Visiting PropertyPolyType.");
        type.getType().accept(this);
    }

    default public void visit(PrimitivePolyType type) {
        log.trace("Visiting PrimitivePolyType.");
        this.visit((PolyType)type);
    }

    default public void visit(AnyPolyType type) {
        log.trace("Visiting AnyPolyType.");
        this.visit((PolyType)type);
    }
}

