/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.model.visitor;

import io.polyapi.plugin.model.specification.Specification;
import io.polyapi.plugin.model.specification.function.ApiFunctionSpecification;
import io.polyapi.plugin.model.specification.function.AuthFunctionSpecification;
import io.polyapi.plugin.model.specification.function.ClientFunctionSpecification;
import io.polyapi.plugin.model.specification.function.FunctionSpecification;
import io.polyapi.plugin.model.specification.function.ServerFunctionSpecification;
import io.polyapi.plugin.model.specification.variable.ServerVariableSpecification;
import io.polyapi.plugin.model.specification.webhook.WebhookHandleSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PolySpecificationVisitor {
    public static final Logger log = LoggerFactory.getLogger(PolySpecificationVisitor.class);

    default public void doVisit(Specification specification) {
        specification.accept(this);
    }

    default public void visit(Specification specification) {
        log.trace("Visiting Specification.");
    }

    default public void visit(FunctionSpecification specification) {
        log.trace("Visiting FunctionSpecification.");
        this.visit((Specification)specification);
    }

    default public void visit(ServerFunctionSpecification specification) {
        log.trace("Visiting ServerFunctionSpecification.");
        this.visit((FunctionSpecification)specification);
    }

    default public void visit(ClientFunctionSpecification specification) {
        log.trace("Visiting CustomFunctionSpecification.");
        this.visit((FunctionSpecification)specification);
    }

    default public void visit(ApiFunctionSpecification specification) {
        log.trace("Visiting ApiFunctionSpecification.");
        this.visit((FunctionSpecification)specification);
    }

    default public void visit(AuthFunctionSpecification specification) {
        log.trace("Visiting AuthFunctionSpecification.");
        this.visit((FunctionSpecification)specification);
    }

    default public void visit(ServerVariableSpecification specification) {
        log.trace("Visiting ServerVariableSpecification.");
        this.visit((Specification)specification);
    }

    default public void visit(WebhookHandleSpecification specification) {
        log.trace("Visiting WebhookHandleSpecification.");
        this.visit((Specification)specification);
    }
}

