/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.model.specification.resolved;

import io.polyapi.plugin.model.generation.KeyValuePair;
import io.polyapi.plugin.model.specification.resolved.ResolvedSpecification;
import io.polyapi.plugin.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ResolvedFunctionSpecification
extends ResolvedSpecification {
    private final String methodName;
    private final List<KeyValuePair<String, String>> arguments;
    private final String returnType;

    public ResolvedFunctionSpecification(ResolvedFunctionSpecification base) {
        this(base.getId(), base.getName(), base.getPackageName(), base.getImports(), base.getClassName(), base.methodName, base.arguments, base.returnType);
    }

    public ResolvedFunctionSpecification(String id, String name, String packageName, Set<String> imports, String className, String methodName, List<KeyValuePair<String, String>> arguments, String returnType) {
        super(id, name, packageName, imports, className);
        this.methodName = methodName;
        this.arguments = new ArrayList<KeyValuePair<String, String>>();
        Optional.ofNullable(arguments).ifPresent(this.arguments::addAll);
        this.returnType = returnType;
    }

    public String getReturnType() {
        String result = Optional.ofNullable(this.returnType).map(String::trim).filter(Predicate.not(String::isBlank)).filter(Predicate.not(Predicate.isEqual(Void.class.getName()))).orElse("void");
        return result.equalsIgnoreCase(Object.class.getName()) ? "<T> T" : result;
    }

    public String getParamNames() {
        return this.toQuotedString(this.arguments.stream().map(KeyValuePair::key).map(StringUtils::toCamelCase));
    }

    public String getParamVariableNames() {
        return this.arguments.stream().map(KeyValuePair::key).map(StringUtils::toCamelCase).collect(Collectors.joining(", "));
    }

    public String getParamTypes() {
        return this.toQuotedString(this.arguments.stream().map(KeyValuePair::value));
    }

    private String toQuotedString(Stream<String> valueStream) {
        return valueStream.map(value -> String.format("\"%s\"", value)).collect(Collectors.joining(", "));
    }

    public String getMethodSignature() {
        return String.format("%s(%s)", this.methodName, this.arguments.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }

    public Boolean isReturnsValue() {
        return !this.getReturnType().equalsIgnoreCase("void");
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<KeyValuePair<String, String>> getArguments() {
        return this.arguments;
    }
}

