/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.model.specification;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.polyapi.plugin.model.specification.IgnoredSpecification;
import io.polyapi.plugin.model.specification.VisibilityMetadata;
import io.polyapi.plugin.model.specification.function.ApiFunctionSpecification;
import io.polyapi.plugin.model.specification.function.AuthFunctionSpecification;
import io.polyapi.plugin.model.specification.function.ClientFunctionSpecification;
import io.polyapi.plugin.model.specification.function.ServerFunctionSpecification;
import io.polyapi.plugin.model.specification.variable.ServerVariableSpecification;
import io.polyapi.plugin.model.specification.webhook.WebhookHandleSpecification;
import io.polyapi.plugin.model.visitor.PolySpecificationVisitor;
import io.polyapi.plugin.utils.StringUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, defaultImpl=IgnoredSpecification.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ApiFunctionSpecification.class, name="apiFunction"), @JsonSubTypes.Type(value=ClientFunctionSpecification.class, name="customFunction"), @JsonSubTypes.Type(value=ServerFunctionSpecification.class, name="serverFunction"), @JsonSubTypes.Type(value=AuthFunctionSpecification.class, name="authFunction"), @JsonSubTypes.Type(value=WebhookHandleSpecification.class, name="webhookHandle"), @JsonSubTypes.Type(value=ServerVariableSpecification.class, name="serverVariable")})
public abstract class Specification {
    private String id;
    private String type;
    private String context;
    private String name;
    private String description;
    private VisibilityMetadata visibilityMetadata;

    public abstract String getSpecificationType();

    public void accept(PolySpecificationVisitor visitor) {
        visitor.visit(this);
    }

    public String getPackageName() {
        return String.format("io.polyapi.%s.%s", Stream.of(this.getSpecificationType(), Optional.ofNullable(this.context).orElse("")).filter(Predicate.not(String::isBlank)).map(String::toLowerCase).collect(Collectors.joining(".")), this.name.toLowerCase());
    }

    public String getClassName() {
        return StringUtils.toPascalCase(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Specification)) {
            return false;
        }
        Specification that = (Specification)o;
        return Objects.equals(this.context, that.context) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.name);
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getContext() {
        return this.context;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public VisibilityMetadata getVisibilityMetadata() {
        return this.visibilityMetadata;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVisibilityMetadata(VisibilityMetadata visibilityMetadata) {
        this.visibilityMetadata = visibilityMetadata;
    }
}

