/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.model.generation;

import io.polyapi.plugin.model.generation.Generable;
import io.polyapi.plugin.model.specification.resolved.ResolvedApiFunctionSpecification;
import io.polyapi.plugin.model.specification.resolved.ResolvedAuthFunctionSpecification;
import io.polyapi.plugin.model.specification.resolved.ResolvedCustomFunctionSpecification;
import io.polyapi.plugin.model.specification.resolved.ResolvedDefaultFunctionSpecification;
import io.polyapi.plugin.model.specification.resolved.ResolvedServerFunctionSpecification;
import io.polyapi.plugin.model.specification.resolved.ResolvedServerVariableSpecification;
import io.polyapi.plugin.model.specification.resolved.ResolvedSpecification;
import io.polyapi.plugin.model.specification.resolved.ResolvedStandardAuthFunctionSpecification;
import io.polyapi.plugin.model.specification.resolved.ResolvedSubresourceAuthFunctionSpecification;
import io.polyapi.plugin.model.specification.resolved.ResolvedWebhookHandleSpecification;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class ResolvedContext
implements Generable {
    private final String name;
    private final String packageName;
    private final Set<String> imports;
    private final String className;
    private final List<ResolvedContext> subcontexts;
    private final List<ResolvedSpecification> specifications;

    public ResolvedContext(String name, String packageName, Set<String> imports, String className, List<ResolvedContext> subcontexts, List<ResolvedSpecification> specifications) {
        this.packageName = packageName;
        this.imports = imports;
        this.name = name;
        this.className = className;
        this.subcontexts = new ArrayList<ResolvedContext>();
        Optional.ofNullable(subcontexts).ifPresent(this.subcontexts::addAll);
        this.specifications = new ArrayList<ResolvedSpecification>();
        Optional.ofNullable(specifications).ifPresent(this.specifications::addAll);
    }

    public List<ResolvedServerFunctionSpecification> getServerFunctionSpecifications() {
        return this.filterSpecifications(ResolvedServerFunctionSpecification.class);
    }

    public List<ResolvedCustomFunctionSpecification> getCustomFunctionSpecifications() {
        return this.filterSpecifications(ResolvedCustomFunctionSpecification.class);
    }

    public List<ResolvedApiFunctionSpecification> getApiFunctionSpecifications() {
        return this.filterSpecifications(ResolvedApiFunctionSpecification.class);
    }

    public List<ResolvedAuthFunctionSpecification> getAuthFunctionSpecification() {
        return this.filterSpecifications(ResolvedAuthFunctionSpecification.class);
    }

    public List<ResolvedSubresourceAuthFunctionSpecification> getSubresourceAuthFunctionSpecifications() {
        return this.filterSpecifications(ResolvedSubresourceAuthFunctionSpecification.class);
    }

    public List<ResolvedStandardAuthFunctionSpecification> getStandardAuthFunctionSpecifications() {
        return this.filterSpecifications(ResolvedStandardAuthFunctionSpecification.class);
    }

    public List<ResolvedServerVariableSpecification> getServerVariableSpecifications() {
        return this.filterSpecifications(ResolvedServerVariableSpecification.class);
    }

    public List<ResolvedWebhookHandleSpecification> getWebhookHandlerSpecifications() {
        return this.filterSpecifications(ResolvedWebhookHandleSpecification.class);
    }

    public List<ResolvedDefaultFunctionSpecification> getFunctionSpecifications() {
        return this.filterSpecifications(ResolvedDefaultFunctionSpecification.class);
    }

    private <T extends ResolvedSpecification> List<T> filterSpecifications(Class<T> resolvedSpecificationClass) {
        return this.specifications.stream().filter(resolvedSpecificationClass::isInstance).map(resolvedSpecificationClass::cast).toList();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    public Set<String> getImports() {
        return this.imports;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public List<ResolvedContext> getSubcontexts() {
        return this.subcontexts;
    }

    public List<ResolvedSpecification> getSpecifications() {
        return this.specifications;
    }
}

