/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.model.generation;

import io.polyapi.plugin.model.specification.Specification;
import io.polyapi.plugin.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class Context {
    private String name;
    private Context parent;
    private List<Context> subcontexts = new ArrayList<Context>();
    private Set<Specification> specifications = new HashSet<Specification>();

    public Context(Context parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public String getPackageName() {
        return Optional.ofNullable(this.parent).map(parentContext -> String.format("%s.context.%s", parentContext.getPackageName(), parentContext.getName().toLowerCase())).orElse("io.polyapi");
    }

    public String getClassName() {
        return StringUtils.toPascalCase(this.name);
    }

    public Context put(Context context) {
        return this.subcontexts.stream().filter(Predicate.isEqual(context)).findAny().orElseGet(() -> {
            this.subcontexts.add(context);
            return context;
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Context)) {
            return false;
        }
        Context that = (Context)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String getName() {
        return this.name;
    }

    public Context getParent() {
        return this.parent;
    }

    public List<Context> getSubcontexts() {
        return this.subcontexts;
    }

    public Set<Specification> getSpecifications() {
        return this.specifications;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParent(Context parent) {
        this.parent = parent;
    }

    public void setSubcontexts(List<Context> subcontexts) {
        this.subcontexts = subcontexts;
    }

    public void setSpecifications(Set<Specification> specifications) {
        this.specifications = specifications;
    }
}

