/*
 * Decompiled with CFR 0.152.
 */
package io.polyapi.plugin.model;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ParsedType {
    private final String baseClass;
    private final List<ParsedType> typeParameters;

    public ParsedType(String baseClass) {
        this(baseClass, new ArrayList<ParsedType>());
    }

    public ParsedType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            this.baseClass = parameterizedType.getRawType().getTypeName();
            this.typeParameters = Arrays.stream(parameterizedType.getActualTypeArguments()).map(ParsedType::new).toList();
        } else {
            this.baseClass = type.getTypeName();
            this.typeParameters = new ArrayList<ParsedType>();
        }
    }

    public String getFullName() {
        return String.format("%s%s", this.baseClass, Optional.of(Optional.ofNullable(this.typeParameters).stream().flatMap(Collection::stream).map(ParsedType::getFullName).collect(Collectors.joining(", "))).filter(Predicate.not(String::isBlank)).map(params -> String.format("<%s>", params)).orElse(""));
    }

    public String getName() {
        return String.format("%s%s", this.baseClass.substring(this.baseClass.lastIndexOf(".")), Optional.of(Optional.ofNullable(this.typeParameters).stream().flatMap(Collection::stream).map(ParsedType::getName).collect(Collectors.joining(", "))).filter(Predicate.not(String::isBlank)).map(params -> String.format("<%s>", params)).orElse(""));
    }

    public Set<String> getTypes() {
        return Stream.concat(Stream.of(this.baseClass), Optional.ofNullable(this.typeParameters).stream().flatMap(Collection::stream).map(ParsedType::getTypes).flatMap(Collection::stream)).collect(Collectors.toSet());
    }

    public String getBaseClass() {
        return this.baseClass;
    }

    public List<ParsedType> getTypeParameters() {
        return this.typeParameters;
    }

    public ParsedType(String baseClass, List<ParsedType> typeParameters) {
        this.baseClass = baseClass;
        this.typeParameters = typeParameters;
    }
}

