/*
 * Peacemakr
 * This API describes the Peacemakr services, which enable seamless application layer encryption and verification.
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.peacemakr.crypto.swagger.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * SymmetricKeyUseDomain
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2020-02-29T21:54:50.815Z")
public class SymmetricKeyUseDomain {
  @SerializedName("id")
  private String id = null;

  @SerializedName("ownerOrgId")
  private String ownerOrgId = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("creationTime")
  private Integer creationTime = null;

  @SerializedName("symmetricKeyInceptionTTL")
  private Integer symmetricKeyInceptionTTL = null;

  @SerializedName("symmetricKeyEncryptionUseTTL")
  private Integer symmetricKeyEncryptionUseTTL = null;

  @SerializedName("symmetricKeyEncryptionAllowed")
  private Boolean symmetricKeyEncryptionAllowed = null;

  @SerializedName("symmetricKeyDecryptionUseTTL")
  private Integer symmetricKeyDecryptionUseTTL = null;

  @SerializedName("symmetricKeyDecryptionAllowed")
  private Boolean symmetricKeyDecryptionAllowed = null;

  @SerializedName("symmetricKeyRetentionUseTTL")
  private Integer symmetricKeyRetentionUseTTL = null;

  @SerializedName("symmetricKeyLength")
  private Integer symmetricKeyLength = null;

  @SerializedName("symmetricKeyEncryptionAlg")
  private String symmetricKeyEncryptionAlg = "CHACHA20_POLY1305";

  @SerializedName("encryptingPackagedCiphertextVersion")
  private Integer encryptingPackagedCiphertextVersion = null;

  @SerializedName("symmetricKeyDerivationServiceId")
  private String symmetricKeyDerivationServiceId = null;

  @SerializedName("encryptionKeyIds")
  private List<String> encryptionKeyIds = new ArrayList<String>();

  @SerializedName("endableKDSFallbackToCloud")
  private Boolean endableKDSFallbackToCloud = null;

  @SerializedName("requireSignedKeyDelivery")
  private Boolean requireSignedKeyDelivery = null;

  @SerializedName("digestAlgorithm")
  private String digestAlgorithm = "SHA_256";

  public SymmetricKeyUseDomain id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(required = true, value = "")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public SymmetricKeyUseDomain ownerOrgId(String ownerOrgId) {
    this.ownerOrgId = ownerOrgId;
    return this;
  }

   /**
   * the org id of the organization that owns these symmetric keys
   * @return ownerOrgId
  **/
  @ApiModelProperty(required = true, value = "the org id of the organization that owns these symmetric keys")
  public String getOwnerOrgId() {
    return ownerOrgId;
  }

  public void setOwnerOrgId(String ownerOrgId) {
    this.ownerOrgId = ownerOrgId;
  }

  public SymmetricKeyUseDomain name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @ApiModelProperty(value = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public SymmetricKeyUseDomain creationTime(Integer creationTime) {
    this.creationTime = creationTime;
    return this;
  }

   /**
   * Get creationTime
   * @return creationTime
  **/
  @ApiModelProperty(required = true, value = "")
  public Integer getCreationTime() {
    return creationTime;
  }

  public void setCreationTime(Integer creationTime) {
    this.creationTime = creationTime;
  }

  public SymmetricKeyUseDomain symmetricKeyInceptionTTL(Integer symmetricKeyInceptionTTL) {
    this.symmetricKeyInceptionTTL = symmetricKeyInceptionTTL;
    return this;
  }

   /**
   * number of seconds since key creation that the key will be available for encryption
   * @return symmetricKeyInceptionTTL
  **/
  @ApiModelProperty(required = true, value = "number of seconds since key creation that the key will be available for encryption")
  public Integer getSymmetricKeyInceptionTTL() {
    return symmetricKeyInceptionTTL;
  }

  public void setSymmetricKeyInceptionTTL(Integer symmetricKeyInceptionTTL) {
    this.symmetricKeyInceptionTTL = symmetricKeyInceptionTTL;
  }

  public SymmetricKeyUseDomain symmetricKeyEncryptionUseTTL(Integer symmetricKeyEncryptionUseTTL) {
    this.symmetricKeyEncryptionUseTTL = symmetricKeyEncryptionUseTTL;
    return this;
  }

   /**
   * number of seconds since key creation that the key will be available for encryption
   * @return symmetricKeyEncryptionUseTTL
  **/
  @ApiModelProperty(required = true, value = "number of seconds since key creation that the key will be available for encryption")
  public Integer getSymmetricKeyEncryptionUseTTL() {
    return symmetricKeyEncryptionUseTTL;
  }

  public void setSymmetricKeyEncryptionUseTTL(Integer symmetricKeyEncryptionUseTTL) {
    this.symmetricKeyEncryptionUseTTL = symmetricKeyEncryptionUseTTL;
  }

  public SymmetricKeyUseDomain symmetricKeyEncryptionAllowed(Boolean symmetricKeyEncryptionAllowed) {
    this.symmetricKeyEncryptionAllowed = symmetricKeyEncryptionAllowed;
    return this;
  }

   /**
   * whether this use domain is available for encryption; if false, these keys should not be used for encrypting new messages
   * @return symmetricKeyEncryptionAllowed
  **/
  @ApiModelProperty(value = "whether this use domain is available for encryption; if false, these keys should not be used for encrypting new messages")
  public Boolean isSymmetricKeyEncryptionAllowed() {
    return symmetricKeyEncryptionAllowed;
  }

  public void setSymmetricKeyEncryptionAllowed(Boolean symmetricKeyEncryptionAllowed) {
    this.symmetricKeyEncryptionAllowed = symmetricKeyEncryptionAllowed;
  }

  public SymmetricKeyUseDomain symmetricKeyDecryptionUseTTL(Integer symmetricKeyDecryptionUseTTL) {
    this.symmetricKeyDecryptionUseTTL = symmetricKeyDecryptionUseTTL;
    return this;
  }

   /**
   * number of seconds since key creation that the key will be available for decryption
   * @return symmetricKeyDecryptionUseTTL
  **/
  @ApiModelProperty(required = true, value = "number of seconds since key creation that the key will be available for decryption")
  public Integer getSymmetricKeyDecryptionUseTTL() {
    return symmetricKeyDecryptionUseTTL;
  }

  public void setSymmetricKeyDecryptionUseTTL(Integer symmetricKeyDecryptionUseTTL) {
    this.symmetricKeyDecryptionUseTTL = symmetricKeyDecryptionUseTTL;
  }

  public SymmetricKeyUseDomain symmetricKeyDecryptionAllowed(Boolean symmetricKeyDecryptionAllowed) {
    this.symmetricKeyDecryptionAllowed = symmetricKeyDecryptionAllowed;
    return this;
  }

   /**
   * whether this use domain is available for decryption; if false, these keys should not be used for decrypting messages
   * @return symmetricKeyDecryptionAllowed
  **/
  @ApiModelProperty(value = "whether this use domain is available for decryption; if false, these keys should not be used for decrypting messages")
  public Boolean isSymmetricKeyDecryptionAllowed() {
    return symmetricKeyDecryptionAllowed;
  }

  public void setSymmetricKeyDecryptionAllowed(Boolean symmetricKeyDecryptionAllowed) {
    this.symmetricKeyDecryptionAllowed = symmetricKeyDecryptionAllowed;
  }

  public SymmetricKeyUseDomain symmetricKeyRetentionUseTTL(Integer symmetricKeyRetentionUseTTL) {
    this.symmetricKeyRetentionUseTTL = symmetricKeyRetentionUseTTL;
    return this;
  }

   /**
   * number of seconds since key creation that the key will be available for retention purposes
   * @return symmetricKeyRetentionUseTTL
  **/
  @ApiModelProperty(required = true, value = "number of seconds since key creation that the key will be available for retention purposes")
  public Integer getSymmetricKeyRetentionUseTTL() {
    return symmetricKeyRetentionUseTTL;
  }

  public void setSymmetricKeyRetentionUseTTL(Integer symmetricKeyRetentionUseTTL) {
    this.symmetricKeyRetentionUseTTL = symmetricKeyRetentionUseTTL;
  }

  public SymmetricKeyUseDomain symmetricKeyLength(Integer symmetricKeyLength) {
    this.symmetricKeyLength = symmetricKeyLength;
    return this;
  }

   /**
   * the number of bits of all symmetric keys in this use domain
   * @return symmetricKeyLength
  **/
  @ApiModelProperty(required = true, value = "the number of bits of all symmetric keys in this use domain")
  public Integer getSymmetricKeyLength() {
    return symmetricKeyLength;
  }

  public void setSymmetricKeyLength(Integer symmetricKeyLength) {
    this.symmetricKeyLength = symmetricKeyLength;
  }

  public SymmetricKeyUseDomain symmetricKeyEncryptionAlg(String symmetricKeyEncryptionAlg) {
    this.symmetricKeyEncryptionAlg = symmetricKeyEncryptionAlg;
    return this;
  }

   /**
   * the specific encryption alg to encrypt new plaintexts for application layer encryption operations
   * @return symmetricKeyEncryptionAlg
  **/
  @ApiModelProperty(required = true, value = "the specific encryption alg to encrypt new plaintexts for application layer encryption operations")
  public String getSymmetricKeyEncryptionAlg() {
    return symmetricKeyEncryptionAlg;
  }

  public void setSymmetricKeyEncryptionAlg(String symmetricKeyEncryptionAlg) {
    this.symmetricKeyEncryptionAlg = symmetricKeyEncryptionAlg;
  }

  public SymmetricKeyUseDomain encryptingPackagedCiphertextVersion(Integer encryptingPackagedCiphertextVersion) {
    this.encryptingPackagedCiphertextVersion = encryptingPackagedCiphertextVersion;
    return this;
  }

   /**
   * after encrypting new plaintexts, package the ciphertext with this version of the packaged ciphertext
   * @return encryptingPackagedCiphertextVersion
  **/
  @ApiModelProperty(required = true, value = "after encrypting new plaintexts, package the ciphertext with this version of the packaged ciphertext")
  public Integer getEncryptingPackagedCiphertextVersion() {
    return encryptingPackagedCiphertextVersion;
  }

  public void setEncryptingPackagedCiphertextVersion(Integer encryptingPackagedCiphertextVersion) {
    this.encryptingPackagedCiphertextVersion = encryptingPackagedCiphertextVersion;
  }

  public SymmetricKeyUseDomain symmetricKeyDerivationServiceId(String symmetricKeyDerivationServiceId) {
    this.symmetricKeyDerivationServiceId = symmetricKeyDerivationServiceId;
    return this;
  }

   /**
   * the symmetric key derivation serivce id that can derive and wrap these keys
   * @return symmetricKeyDerivationServiceId
  **/
  @ApiModelProperty(required = true, value = "the symmetric key derivation serivce id that can derive and wrap these keys")
  public String getSymmetricKeyDerivationServiceId() {
    return symmetricKeyDerivationServiceId;
  }

  public void setSymmetricKeyDerivationServiceId(String symmetricKeyDerivationServiceId) {
    this.symmetricKeyDerivationServiceId = symmetricKeyDerivationServiceId;
  }

  public SymmetricKeyUseDomain encryptionKeyIds(List<String> encryptionKeyIds) {
    this.encryptionKeyIds = encryptionKeyIds;
    return this;
  }

  public SymmetricKeyUseDomain addEncryptionKeyIdsItem(String encryptionKeyIdsItem) {
    this.encryptionKeyIds.add(encryptionKeyIdsItem);
    return this;
  }

   /**
   * these are the semmetric key id&#39;s that belong to this use domain - these keys never belong to any other use domain
   * @return encryptionKeyIds
  **/
  @ApiModelProperty(required = true, value = "these are the semmetric key id's that belong to this use domain - these keys never belong to any other use domain")
  public List<String> getEncryptionKeyIds() {
    return encryptionKeyIds;
  }

  public void setEncryptionKeyIds(List<String> encryptionKeyIds) {
    this.encryptionKeyIds = encryptionKeyIds;
  }

  public SymmetricKeyUseDomain endableKDSFallbackToCloud(Boolean endableKDSFallbackToCloud) {
    this.endableKDSFallbackToCloud = endableKDSFallbackToCloud;
    return this;
  }

   /**
   * if all registered kds service become unreachable, then incoming requests for new and existing keys may fallback to the cloud provided KDS
   * @return endableKDSFallbackToCloud
  **/
  @ApiModelProperty(required = true, value = "if all registered kds service become unreachable, then incoming requests for new and existing keys may fallback to the cloud provided KDS")
  public Boolean isEndableKDSFallbackToCloud() {
    return endableKDSFallbackToCloud;
  }

  public void setEndableKDSFallbackToCloud(Boolean endableKDSFallbackToCloud) {
    this.endableKDSFallbackToCloud = endableKDSFallbackToCloud;
  }

  public SymmetricKeyUseDomain requireSignedKeyDelivery(Boolean requireSignedKeyDelivery) {
    this.requireSignedKeyDelivery = requireSignedKeyDelivery;
    return this;
  }

   /**
   * if required, all clients must receive these keys in a signed symmetric key delivery from the key deriver
   * @return requireSignedKeyDelivery
  **/
  @ApiModelProperty(required = true, value = "if required, all clients must receive these keys in a signed symmetric key delivery from the key deriver")
  public Boolean isRequireSignedKeyDelivery() {
    return requireSignedKeyDelivery;
  }

  public void setRequireSignedKeyDelivery(Boolean requireSignedKeyDelivery) {
    this.requireSignedKeyDelivery = requireSignedKeyDelivery;
  }

  public SymmetricKeyUseDomain digestAlgorithm(String digestAlgorithm) {
    this.digestAlgorithm = digestAlgorithm;
    return this;
  }

   /**
   * The digest algorithm to use for signing messages in this use domain
   * @return digestAlgorithm
  **/
  @ApiModelProperty(value = "The digest algorithm to use for signing messages in this use domain")
  public String getDigestAlgorithm() {
    return digestAlgorithm;
  }

  public void setDigestAlgorithm(String digestAlgorithm) {
    this.digestAlgorithm = digestAlgorithm;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SymmetricKeyUseDomain symmetricKeyUseDomain = (SymmetricKeyUseDomain) o;
    return Objects.equals(this.id, symmetricKeyUseDomain.id) &&
        Objects.equals(this.ownerOrgId, symmetricKeyUseDomain.ownerOrgId) &&
        Objects.equals(this.name, symmetricKeyUseDomain.name) &&
        Objects.equals(this.creationTime, symmetricKeyUseDomain.creationTime) &&
        Objects.equals(this.symmetricKeyInceptionTTL, symmetricKeyUseDomain.symmetricKeyInceptionTTL) &&
        Objects.equals(this.symmetricKeyEncryptionUseTTL, symmetricKeyUseDomain.symmetricKeyEncryptionUseTTL) &&
        Objects.equals(this.symmetricKeyEncryptionAllowed, symmetricKeyUseDomain.symmetricKeyEncryptionAllowed) &&
        Objects.equals(this.symmetricKeyDecryptionUseTTL, symmetricKeyUseDomain.symmetricKeyDecryptionUseTTL) &&
        Objects.equals(this.symmetricKeyDecryptionAllowed, symmetricKeyUseDomain.symmetricKeyDecryptionAllowed) &&
        Objects.equals(this.symmetricKeyRetentionUseTTL, symmetricKeyUseDomain.symmetricKeyRetentionUseTTL) &&
        Objects.equals(this.symmetricKeyLength, symmetricKeyUseDomain.symmetricKeyLength) &&
        Objects.equals(this.symmetricKeyEncryptionAlg, symmetricKeyUseDomain.symmetricKeyEncryptionAlg) &&
        Objects.equals(this.encryptingPackagedCiphertextVersion, symmetricKeyUseDomain.encryptingPackagedCiphertextVersion) &&
        Objects.equals(this.symmetricKeyDerivationServiceId, symmetricKeyUseDomain.symmetricKeyDerivationServiceId) &&
        Objects.equals(this.encryptionKeyIds, symmetricKeyUseDomain.encryptionKeyIds) &&
        Objects.equals(this.endableKDSFallbackToCloud, symmetricKeyUseDomain.endableKDSFallbackToCloud) &&
        Objects.equals(this.requireSignedKeyDelivery, symmetricKeyUseDomain.requireSignedKeyDelivery) &&
        Objects.equals(this.digestAlgorithm, symmetricKeyUseDomain.digestAlgorithm);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, ownerOrgId, name, creationTime, symmetricKeyInceptionTTL, symmetricKeyEncryptionUseTTL, symmetricKeyEncryptionAllowed, symmetricKeyDecryptionUseTTL, symmetricKeyDecryptionAllowed, symmetricKeyRetentionUseTTL, symmetricKeyLength, symmetricKeyEncryptionAlg, encryptingPackagedCiphertextVersion, symmetricKeyDerivationServiceId, encryptionKeyIds, endableKDSFallbackToCloud, requireSignedKeyDelivery, digestAlgorithm);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SymmetricKeyUseDomain {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    ownerOrgId: ").append(toIndentedString(ownerOrgId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    creationTime: ").append(toIndentedString(creationTime)).append("\n");
    sb.append("    symmetricKeyInceptionTTL: ").append(toIndentedString(symmetricKeyInceptionTTL)).append("\n");
    sb.append("    symmetricKeyEncryptionUseTTL: ").append(toIndentedString(symmetricKeyEncryptionUseTTL)).append("\n");
    sb.append("    symmetricKeyEncryptionAllowed: ").append(toIndentedString(symmetricKeyEncryptionAllowed)).append("\n");
    sb.append("    symmetricKeyDecryptionUseTTL: ").append(toIndentedString(symmetricKeyDecryptionUseTTL)).append("\n");
    sb.append("    symmetricKeyDecryptionAllowed: ").append(toIndentedString(symmetricKeyDecryptionAllowed)).append("\n");
    sb.append("    symmetricKeyRetentionUseTTL: ").append(toIndentedString(symmetricKeyRetentionUseTTL)).append("\n");
    sb.append("    symmetricKeyLength: ").append(toIndentedString(symmetricKeyLength)).append("\n");
    sb.append("    symmetricKeyEncryptionAlg: ").append(toIndentedString(symmetricKeyEncryptionAlg)).append("\n");
    sb.append("    encryptingPackagedCiphertextVersion: ").append(toIndentedString(encryptingPackagedCiphertextVersion)).append("\n");
    sb.append("    symmetricKeyDerivationServiceId: ").append(toIndentedString(symmetricKeyDerivationServiceId)).append("\n");
    sb.append("    encryptionKeyIds: ").append(toIndentedString(encryptionKeyIds)).append("\n");
    sb.append("    endableKDSFallbackToCloud: ").append(toIndentedString(endableKDSFallbackToCloud)).append("\n");
    sb.append("    requireSignedKeyDelivery: ").append(toIndentedString(requireSignedKeyDelivery)).append("\n");
    sb.append("    digestAlgorithm: ").append(toIndentedString(digestAlgorithm)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

