/*
 * Peacemakr
 * This API describes the Peacemakr services, which enable seamless application layer encryption and verification.
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.peacemakr.crypto.swagger.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * SymmetricKeyRequest
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2020-02-29T21:54:50.815Z")
public class SymmetricKeyRequest {
  @SerializedName("id")
  private String id = null;

  @SerializedName("deriveSymmetricKeyIds")
  private List<String> deriveSymmetricKeyIds = new ArrayList<String>();

  @SerializedName("deliveryPublicKeyIds")
  private List<String> deliveryPublicKeyIds = new ArrayList<String>();

  @SerializedName("keyDerivationServiceId")
  private String keyDerivationServiceId = null;

  @SerializedName("creationTime")
  private Integer creationTime = null;

  @SerializedName("symmetricKeyLength")
  private Integer symmetricKeyLength = null;

  @SerializedName("packagedCiphertextVersion")
  private Integer packagedCiphertextVersion = null;

  @SerializedName("mustSignDeliveredSymmetricKeys")
  private Boolean mustSignDeliveredSymmetricKeys = null;

  public SymmetricKeyRequest id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Id of the symmetric key request.
   * @return id
  **/
  @ApiModelProperty(required = true, value = "Id of the symmetric key request.")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public SymmetricKeyRequest deriveSymmetricKeyIds(List<String> deriveSymmetricKeyIds) {
    this.deriveSymmetricKeyIds = deriveSymmetricKeyIds;
    return this;
  }

  public SymmetricKeyRequest addDeriveSymmetricKeyIdsItem(String deriveSymmetricKeyIdsItem) {
    this.deriveSymmetricKeyIds.add(deriveSymmetricKeyIdsItem);
    return this;
  }

   /**
   * These are the keyId&#39;s of for the symmetric keys to actually derive.
   * @return deriveSymmetricKeyIds
  **/
  @ApiModelProperty(required = true, value = "These are the keyId's of for the symmetric keys to actually derive.")
  public List<String> getDeriveSymmetricKeyIds() {
    return deriveSymmetricKeyIds;
  }

  public void setDeriveSymmetricKeyIds(List<String> deriveSymmetricKeyIds) {
    this.deriveSymmetricKeyIds = deriveSymmetricKeyIds;
  }

  public SymmetricKeyRequest deliveryPublicKeyIds(List<String> deliveryPublicKeyIds) {
    this.deliveryPublicKeyIds = deliveryPublicKeyIds;
    return this;
  }

  public SymmetricKeyRequest addDeliveryPublicKeyIdsItem(String deliveryPublicKeyIdsItem) {
    this.deliveryPublicKeyIds.add(deliveryPublicKeyIdsItem);
    return this;
  }

   /**
   * These are the keyId&#39;s to deliver all of the derived symmetric keys.
   * @return deliveryPublicKeyIds
  **/
  @ApiModelProperty(required = true, value = "These are the keyId's to deliver all of the derived symmetric keys.")
  public List<String> getDeliveryPublicKeyIds() {
    return deliveryPublicKeyIds;
  }

  public void setDeliveryPublicKeyIds(List<String> deliveryPublicKeyIds) {
    this.deliveryPublicKeyIds = deliveryPublicKeyIds;
  }

  public SymmetricKeyRequest keyDerivationServiceId(String keyDerivationServiceId) {
    this.keyDerivationServiceId = keyDerivationServiceId;
    return this;
  }

   /**
   * The serviceId that must generate these keys.
   * @return keyDerivationServiceId
  **/
  @ApiModelProperty(required = true, value = "The serviceId that must generate these keys.")
  public String getKeyDerivationServiceId() {
    return keyDerivationServiceId;
  }

  public void setKeyDerivationServiceId(String keyDerivationServiceId) {
    this.keyDerivationServiceId = keyDerivationServiceId;
  }

  public SymmetricKeyRequest creationTime(Integer creationTime) {
    this.creationTime = creationTime;
    return this;
  }

   /**
   * Epoch time of the symmetric key requestion request time.
   * @return creationTime
  **/
  @ApiModelProperty(required = true, value = "Epoch time of the symmetric key requestion request time.")
  public Integer getCreationTime() {
    return creationTime;
  }

  public void setCreationTime(Integer creationTime) {
    this.creationTime = creationTime;
  }

  public SymmetricKeyRequest symmetricKeyLength(Integer symmetricKeyLength) {
    this.symmetricKeyLength = symmetricKeyLength;
    return this;
  }

   /**
   * Length in bytes of the derived symmetric keys.
   * @return symmetricKeyLength
  **/
  @ApiModelProperty(required = true, value = "Length in bytes of the derived symmetric keys.")
  public Integer getSymmetricKeyLength() {
    return symmetricKeyLength;
  }

  public void setSymmetricKeyLength(Integer symmetricKeyLength) {
    this.symmetricKeyLength = symmetricKeyLength;
  }

  public SymmetricKeyRequest packagedCiphertextVersion(Integer packagedCiphertextVersion) {
    this.packagedCiphertextVersion = packagedCiphertextVersion;
    return this;
  }

   /**
   * After deriving symmetric keys, this determines the ciphertext packaging scheme required for encrypted key delivery.
   * @return packagedCiphertextVersion
  **/
  @ApiModelProperty(required = true, value = "After deriving symmetric keys, this determines the ciphertext packaging scheme required for encrypted key delivery.")
  public Integer getPackagedCiphertextVersion() {
    return packagedCiphertextVersion;
  }

  public void setPackagedCiphertextVersion(Integer packagedCiphertextVersion) {
    this.packagedCiphertextVersion = packagedCiphertextVersion;
  }

  public SymmetricKeyRequest mustSignDeliveredSymmetricKeys(Boolean mustSignDeliveredSymmetricKeys) {
    this.mustSignDeliveredSymmetricKeys = mustSignDeliveredSymmetricKeys;
    return this;
  }

   /**
   * If true the key deriver must sign delivered symmetric keys ciphertext blobs
   * @return mustSignDeliveredSymmetricKeys
  **/
  @ApiModelProperty(required = true, value = "If true the key deriver must sign delivered symmetric keys ciphertext blobs")
  public Boolean isMustSignDeliveredSymmetricKeys() {
    return mustSignDeliveredSymmetricKeys;
  }

  public void setMustSignDeliveredSymmetricKeys(Boolean mustSignDeliveredSymmetricKeys) {
    this.mustSignDeliveredSymmetricKeys = mustSignDeliveredSymmetricKeys;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SymmetricKeyRequest symmetricKeyRequest = (SymmetricKeyRequest) o;
    return Objects.equals(this.id, symmetricKeyRequest.id) &&
        Objects.equals(this.deriveSymmetricKeyIds, symmetricKeyRequest.deriveSymmetricKeyIds) &&
        Objects.equals(this.deliveryPublicKeyIds, symmetricKeyRequest.deliveryPublicKeyIds) &&
        Objects.equals(this.keyDerivationServiceId, symmetricKeyRequest.keyDerivationServiceId) &&
        Objects.equals(this.creationTime, symmetricKeyRequest.creationTime) &&
        Objects.equals(this.symmetricKeyLength, symmetricKeyRequest.symmetricKeyLength) &&
        Objects.equals(this.packagedCiphertextVersion, symmetricKeyRequest.packagedCiphertextVersion) &&
        Objects.equals(this.mustSignDeliveredSymmetricKeys, symmetricKeyRequest.mustSignDeliveredSymmetricKeys);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, deriveSymmetricKeyIds, deliveryPublicKeyIds, keyDerivationServiceId, creationTime, symmetricKeyLength, packagedCiphertextVersion, mustSignDeliveredSymmetricKeys);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SymmetricKeyRequest {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    deriveSymmetricKeyIds: ").append(toIndentedString(deriveSymmetricKeyIds)).append("\n");
    sb.append("    deliveryPublicKeyIds: ").append(toIndentedString(deliveryPublicKeyIds)).append("\n");
    sb.append("    keyDerivationServiceId: ").append(toIndentedString(keyDerivationServiceId)).append("\n");
    sb.append("    creationTime: ").append(toIndentedString(creationTime)).append("\n");
    sb.append("    symmetricKeyLength: ").append(toIndentedString(symmetricKeyLength)).append("\n");
    sb.append("    packagedCiphertextVersion: ").append(toIndentedString(packagedCiphertextVersion)).append("\n");
    sb.append("    mustSignDeliveredSymmetricKeys: ").append(toIndentedString(mustSignDeliveredSymmetricKeys)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

