/*
 * Peacemakr
 * This API describes the Peacemakr services, which enable seamless application layer encryption and verification.
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.peacemakr.crypto.swagger.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * PublicKey
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2020-02-29T21:54:50.815Z")
public class PublicKey {
  @SerializedName("id")
  private String id = null;

  @SerializedName("creationTime")
  private Integer creationTime = null;

  @SerializedName("keyType")
  private String keyType = null;

  @SerializedName("encoding")
  private String encoding = null;

  @SerializedName("key")
  private String key = null;

  @SerializedName("owningClientId")
  private String owningClientId = null;

  @SerializedName("owningOrgId")
  private String owningOrgId = null;

  public PublicKey id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(required = true, value = "")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public PublicKey creationTime(Integer creationTime) {
    this.creationTime = creationTime;
    return this;
  }

   /**
   * Get creationTime
   * @return creationTime
  **/
  @ApiModelProperty(required = true, value = "")
  public Integer getCreationTime() {
    return creationTime;
  }

  public void setCreationTime(Integer creationTime) {
    this.creationTime = creationTime;
  }

  public PublicKey keyType(String keyType) {
    this.keyType = keyType;
    return this;
  }

   /**
   * Get keyType
   * @return keyType
  **/
  @ApiModelProperty(example = "ec", required = true, value = "")
  public String getKeyType() {
    return keyType;
  }

  public void setKeyType(String keyType) {
    this.keyType = keyType;
  }

  public PublicKey encoding(String encoding) {
    this.encoding = encoding;
    return this;
  }

   /**
   * Get encoding
   * @return encoding
  **/
  @ApiModelProperty(example = "pem", required = true, value = "")
  public String getEncoding() {
    return encoding;
  }

  public void setEncoding(String encoding) {
    this.encoding = encoding;
  }

  public PublicKey key(String key) {
    this.key = key;
    return this;
  }

   /**
   * Get key
   * @return key
  **/
  @ApiModelProperty(required = true, value = "")
  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public PublicKey owningClientId(String owningClientId) {
    this.owningClientId = owningClientId;
    return this;
  }

   /**
   * the id of the client that owns this specific public key
   * @return owningClientId
  **/
  @ApiModelProperty(value = "the id of the client that owns this specific public key")
  public String getOwningClientId() {
    return owningClientId;
  }

  public void setOwningClientId(String owningClientId) {
    this.owningClientId = owningClientId;
  }

  public PublicKey owningOrgId(String owningOrgId) {
    this.owningOrgId = owningOrgId;
    return this;
  }

   /**
   * the id of the org that owns the client that owns this specific public key
   * @return owningOrgId
  **/
  @ApiModelProperty(value = "the id of the org that owns the client that owns this specific public key")
  public String getOwningOrgId() {
    return owningOrgId;
  }

  public void setOwningOrgId(String owningOrgId) {
    this.owningOrgId = owningOrgId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PublicKey publicKey = (PublicKey) o;
    return Objects.equals(this.id, publicKey.id) &&
        Objects.equals(this.creationTime, publicKey.creationTime) &&
        Objects.equals(this.keyType, publicKey.keyType) &&
        Objects.equals(this.encoding, publicKey.encoding) &&
        Objects.equals(this.key, publicKey.key) &&
        Objects.equals(this.owningClientId, publicKey.owningClientId) &&
        Objects.equals(this.owningOrgId, publicKey.owningOrgId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, creationTime, keyType, encoding, key, owningClientId, owningOrgId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PublicKey {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    creationTime: ").append(toIndentedString(creationTime)).append("\n");
    sb.append("    keyType: ").append(toIndentedString(keyType)).append("\n");
    sb.append("    encoding: ").append(toIndentedString(encoding)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    owningClientId: ").append(toIndentedString(owningClientId)).append("\n");
    sb.append("    owningOrgId: ").append(toIndentedString(owningOrgId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

