/*
 * Peacemakr
 * This API describes the Peacemakr services, which enable seamless application layer encryption and verification.
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.peacemakr.crypto.swagger.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.peacemakr.crypto.swagger.client.model.APIKey;
import io.peacemakr.crypto.swagger.client.model.Contact;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Organization
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2020-02-29T21:54:50.815Z")
public class Organization {
  @SerializedName("id")
  private String id = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("contacts")
  private List<Contact> contacts = new ArrayList<Contact>();

  @SerializedName("stripeCustomerId")
  private String stripeCustomerId = null;

  @SerializedName("clientIds")
  private List<String> clientIds = new ArrayList<String>();

  @SerializedName("apiKeys")
  private List<APIKey> apiKeys = new ArrayList<APIKey>();

  @SerializedName("cryptoConfigId")
  private String cryptoConfigId = null;

  public Organization id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(required = true, value = "")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Organization name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @ApiModelProperty(required = true, value = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Organization contacts(List<Contact> contacts) {
    this.contacts = contacts;
    return this;
  }

  public Organization addContactsItem(Contact contactsItem) {
    this.contacts.add(contactsItem);
    return this;
  }

   /**
   * Get contacts
   * @return contacts
  **/
  @ApiModelProperty(required = true, value = "")
  public List<Contact> getContacts() {
    return contacts;
  }

  public void setContacts(List<Contact> contacts) {
    this.contacts = contacts;
  }

  public Organization stripeCustomerId(String stripeCustomerId) {
    this.stripeCustomerId = stripeCustomerId;
    return this;
  }

   /**
   * Identifies the the customer in Stripe associated with this org
   * @return stripeCustomerId
  **/
  @ApiModelProperty(required = true, value = "Identifies the the customer in Stripe associated with this org")
  public String getStripeCustomerId() {
    return stripeCustomerId;
  }

  public void setStripeCustomerId(String stripeCustomerId) {
    this.stripeCustomerId = stripeCustomerId;
  }

  public Organization clientIds(List<String> clientIds) {
    this.clientIds = clientIds;
    return this;
  }

  public Organization addClientIdsItem(String clientIdsItem) {
    this.clientIds.add(clientIdsItem);
    return this;
  }

   /**
   * Array of client id&#39;s registered to this org
   * @return clientIds
  **/
  @ApiModelProperty(required = true, value = "Array of client id's registered to this org")
  public List<String> getClientIds() {
    return clientIds;
  }

  public void setClientIds(List<String> clientIds) {
    this.clientIds = clientIds;
  }

  public Organization apiKeys(List<APIKey> apiKeys) {
    this.apiKeys = apiKeys;
    return this;
  }

  public Organization addApiKeysItem(APIKey apiKeysItem) {
    this.apiKeys.add(apiKeysItem);
    return this;
  }

   /**
   * Array of api keys registered to this org
   * @return apiKeys
  **/
  @ApiModelProperty(required = true, value = "Array of api keys registered to this org")
  public List<APIKey> getApiKeys() {
    return apiKeys;
  }

  public void setApiKeys(List<APIKey> apiKeys) {
    this.apiKeys = apiKeys;
  }

  public Organization cryptoConfigId(String cryptoConfigId) {
    this.cryptoConfigId = cryptoConfigId;
    return this;
  }

   /**
   * cryptoconfigId of this org
   * @return cryptoConfigId
  **/
  @ApiModelProperty(required = true, value = "cryptoconfigId of this org")
  public String getCryptoConfigId() {
    return cryptoConfigId;
  }

  public void setCryptoConfigId(String cryptoConfigId) {
    this.cryptoConfigId = cryptoConfigId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Organization organization = (Organization) o;
    return Objects.equals(this.id, organization.id) &&
        Objects.equals(this.name, organization.name) &&
        Objects.equals(this.contacts, organization.contacts) &&
        Objects.equals(this.stripeCustomerId, organization.stripeCustomerId) &&
        Objects.equals(this.clientIds, organization.clientIds) &&
        Objects.equals(this.apiKeys, organization.apiKeys) &&
        Objects.equals(this.cryptoConfigId, organization.cryptoConfigId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, contacts, stripeCustomerId, clientIds, apiKeys, cryptoConfigId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Organization {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    contacts: ").append(toIndentedString(contacts)).append("\n");
    sb.append("    stripeCustomerId: ").append(toIndentedString(stripeCustomerId)).append("\n");
    sb.append("    clientIds: ").append(toIndentedString(clientIds)).append("\n");
    sb.append("    apiKeys: ").append(toIndentedString(apiKeys)).append("\n");
    sb.append("    cryptoConfigId: ").append(toIndentedString(cryptoConfigId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

