/*
 * Peacemakr
 * This API describes the Peacemakr services, which enable seamless application layer encryption and verification.
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.peacemakr.crypto.swagger.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * KeyDerivationInstance
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2020-02-29T21:54:50.815Z")
public class KeyDerivationInstance {
  @SerializedName("id")
  private String id = null;

  @SerializedName("serviceIds")
  private List<String> serviceIds = new ArrayList<String>();

  @SerializedName("active")
  private Boolean active = null;

  @SerializedName("version")
  private String version = null;

  @SerializedName("baseUrl")
  private String baseUrl = null;

  @SerializedName("isPublic")
  private Boolean isPublic = false;

  public KeyDerivationInstance id(String id) {
    this.id = id;
    return this;
  }

   /**
   * instance id (concrete instance)
   * @return id
  **/
  @ApiModelProperty(required = true, value = "instance id (concrete instance)")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public KeyDerivationInstance serviceIds(List<String> serviceIds) {
    this.serviceIds = serviceIds;
    return this;
  }

  public KeyDerivationInstance addServiceIdsItem(String serviceIdsItem) {
    this.serviceIds.add(serviceIdsItem);
    return this;
  }

   /**
   * service id (virtual service id)
   * @return serviceIds
  **/
  @ApiModelProperty(required = true, value = "service id (virtual service id)")
  public List<String> getServiceIds() {
    return serviceIds;
  }

  public void setServiceIds(List<String> serviceIds) {
    this.serviceIds = serviceIds;
  }

  public KeyDerivationInstance active(Boolean active) {
    this.active = active;
    return this;
  }

   /**
   * currently online and accepting requests for key derivation
   * @return active
  **/
  @ApiModelProperty(required = true, value = "currently online and accepting requests for key derivation")
  public Boolean isActive() {
    return active;
  }

  public void setActive(Boolean active) {
    this.active = active;
  }

  public KeyDerivationInstance version(String version) {
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @ApiModelProperty(required = true, value = "")
  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  public KeyDerivationInstance baseUrl(String baseUrl) {
    this.baseUrl = baseUrl;
    return this;
  }

   /**
   * base URL from which this key deriver instance will respond to new key derivation job requests
   * @return baseUrl
  **/
  @ApiModelProperty(value = "base URL from which this key deriver instance will respond to new key derivation job requests")
  public String getBaseUrl() {
    return baseUrl;
  }

  public void setBaseUrl(String baseUrl) {
    this.baseUrl = baseUrl;
  }

  public KeyDerivationInstance isPublic(Boolean isPublic) {
    this.isPublic = isPublic;
    return this;
  }

   /**
   * if true then the key deriver is visible to every other organization
   * @return isPublic
  **/
  @ApiModelProperty(value = "if true then the key deriver is visible to every other organization")
  public Boolean isIsPublic() {
    return isPublic;
  }

  public void setIsPublic(Boolean isPublic) {
    this.isPublic = isPublic;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    KeyDerivationInstance keyDerivationInstance = (KeyDerivationInstance) o;
    return Objects.equals(this.id, keyDerivationInstance.id) &&
        Objects.equals(this.serviceIds, keyDerivationInstance.serviceIds) &&
        Objects.equals(this.active, keyDerivationInstance.active) &&
        Objects.equals(this.version, keyDerivationInstance.version) &&
        Objects.equals(this.baseUrl, keyDerivationInstance.baseUrl) &&
        Objects.equals(this.isPublic, keyDerivationInstance.isPublic);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, serviceIds, active, version, baseUrl, isPublic);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class KeyDerivationInstance {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    serviceIds: ").append(toIndentedString(serviceIds)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    baseUrl: ").append(toIndentedString(baseUrl)).append("\n");
    sb.append("    isPublic: ").append(toIndentedString(isPublic)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

