/*
 * Peacemakr
 * This API describes the Peacemakr services, which enable seamless application layer encryption and verification.
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.peacemakr.crypto.swagger.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * EncryptedSymmetricKey
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2020-02-29T21:54:50.815Z")
public class EncryptedSymmetricKey {
  @SerializedName("keyIds")
  private List<String> keyIds = new ArrayList<String>();

  @SerializedName("keyLength")
  private Integer keyLength = null;

  @SerializedName("symmetricKeyUseDomainId")
  private String symmetricKeyUseDomainId = null;

  @SerializedName("packagedCiphertext")
  private String packagedCiphertext = null;

  public EncryptedSymmetricKey keyIds(List<String> keyIds) {
    this.keyIds = keyIds;
    return this;
  }

  public EncryptedSymmetricKey addKeyIdsItem(String keyIdsItem) {
    this.keyIds.add(keyIdsItem);
    return this;
  }

   /**
   * id&#39;s of the symmetric keys encrypted in packedCiphertext
   * @return keyIds
  **/
  @ApiModelProperty(required = true, value = "id's of the symmetric keys encrypted in packedCiphertext")
  public List<String> getKeyIds() {
    return keyIds;
  }

  public void setKeyIds(List<String> keyIds) {
    this.keyIds = keyIds;
  }

  public EncryptedSymmetricKey keyLength(Integer keyLength) {
    this.keyLength = keyLength;
    return this;
  }

   /**
   * length of the keys encrypted in packedCiphertext
   * @return keyLength
  **/
  @ApiModelProperty(required = true, value = "length of the keys encrypted in packedCiphertext")
  public Integer getKeyLength() {
    return keyLength;
  }

  public void setKeyLength(Integer keyLength) {
    this.keyLength = keyLength;
  }

  public EncryptedSymmetricKey symmetricKeyUseDomainId(String symmetricKeyUseDomainId) {
    this.symmetricKeyUseDomainId = symmetricKeyUseDomainId;
    return this;
  }

   /**
   * id of the symmetric key use domain which contains this key
   * @return symmetricKeyUseDomainId
  **/
  @ApiModelProperty(required = true, value = "id of the symmetric key use domain which contains this key")
  public String getSymmetricKeyUseDomainId() {
    return symmetricKeyUseDomainId;
  }

  public void setSymmetricKeyUseDomainId(String symmetricKeyUseDomainId) {
    this.symmetricKeyUseDomainId = symmetricKeyUseDomainId;
  }

  public EncryptedSymmetricKey packagedCiphertext(String packagedCiphertext) {
    this.packagedCiphertext = packagedCiphertext;
    return this;
  }

   /**
   * the actual packaged ciphertext of the encrypted symmetric key, of key
   * @return packagedCiphertext
  **/
  @ApiModelProperty(required = true, value = "the actual packaged ciphertext of the encrypted symmetric key, of key")
  public String getPackagedCiphertext() {
    return packagedCiphertext;
  }

  public void setPackagedCiphertext(String packagedCiphertext) {
    this.packagedCiphertext = packagedCiphertext;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EncryptedSymmetricKey encryptedSymmetricKey = (EncryptedSymmetricKey) o;
    return Objects.equals(this.keyIds, encryptedSymmetricKey.keyIds) &&
        Objects.equals(this.keyLength, encryptedSymmetricKey.keyLength) &&
        Objects.equals(this.symmetricKeyUseDomainId, encryptedSymmetricKey.symmetricKeyUseDomainId) &&
        Objects.equals(this.packagedCiphertext, encryptedSymmetricKey.packagedCiphertext);
  }

  @Override
  public int hashCode() {
    return Objects.hash(keyIds, keyLength, symmetricKeyUseDomainId, packagedCiphertext);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EncryptedSymmetricKey {\n");
    
    sb.append("    keyIds: ").append(toIndentedString(keyIds)).append("\n");
    sb.append("    keyLength: ").append(toIndentedString(keyLength)).append("\n");
    sb.append("    symmetricKeyUseDomainId: ").append(toIndentedString(symmetricKeyUseDomainId)).append("\n");
    sb.append("    packagedCiphertext: ").append(toIndentedString(packagedCiphertext)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

