/*
 * Peacemakr
 * This API describes the Peacemakr services, which enable seamless application layer encryption and verification.
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.peacemakr.crypto.swagger.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.peacemakr.crypto.swagger.client.model.SymmetricKeyUseDomain;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * CryptoConfig
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2020-02-29T21:54:50.815Z")
public class CryptoConfig {
  @SerializedName("id")
  private String id = null;

  @SerializedName("symmetricKeyUseDomains")
  private List<SymmetricKeyUseDomain> symmetricKeyUseDomains = new ArrayList<SymmetricKeyUseDomain>();

  @SerializedName("symmetricKeyUseDomainSelectorScheme")
  private String symmetricKeyUseDomainSelectorScheme = null;

  @SerializedName("ownerOrgId")
  private String ownerOrgId = null;

  @SerializedName("clientKeyType")
  private String clientKeyType = null;

  @SerializedName("clientKeyBitlength")
  private Integer clientKeyBitlength = null;

  @SerializedName("clientKeyTTL")
  private Integer clientKeyTTL = null;

  public CryptoConfig id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(required = true, value = "")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public CryptoConfig symmetricKeyUseDomains(List<SymmetricKeyUseDomain> symmetricKeyUseDomains) {
    this.symmetricKeyUseDomains = symmetricKeyUseDomains;
    return this;
  }

  public CryptoConfig addSymmetricKeyUseDomainsItem(SymmetricKeyUseDomain symmetricKeyUseDomainsItem) {
    this.symmetricKeyUseDomains.add(symmetricKeyUseDomainsItem);
    return this;
  }

   /**
   * every application layer encryption must select a key to use from one specific active semmetric key encryption domain. this is an array of encryption domains id&#39;s that are currently available for encryption
   * @return symmetricKeyUseDomains
  **/
  @ApiModelProperty(required = true, value = "every application layer encryption must select a key to use from one specific active semmetric key encryption domain. this is an array of encryption domains id's that are currently available for encryption")
  public List<SymmetricKeyUseDomain> getSymmetricKeyUseDomains() {
    return symmetricKeyUseDomains;
  }

  public void setSymmetricKeyUseDomains(List<SymmetricKeyUseDomain> symmetricKeyUseDomains) {
    this.symmetricKeyUseDomains = symmetricKeyUseDomains;
  }

  public CryptoConfig symmetricKeyUseDomainSelectorScheme(String symmetricKeyUseDomainSelectorScheme) {
    this.symmetricKeyUseDomainSelectorScheme = symmetricKeyUseDomainSelectorScheme;
    return this;
  }

   /**
   * to guide SDK&#39;s on how to select an encryption domain, a selectorScheme helps an SDK map a encryption request to a set of keys and encryption algoritm
   * @return symmetricKeyUseDomainSelectorScheme
  **/
  @ApiModelProperty(example = "moduloIdentifier", required = true, value = "to guide SDK's on how to select an encryption domain, a selectorScheme helps an SDK map a encryption request to a set of keys and encryption algoritm")
  public String getSymmetricKeyUseDomainSelectorScheme() {
    return symmetricKeyUseDomainSelectorScheme;
  }

  public void setSymmetricKeyUseDomainSelectorScheme(String symmetricKeyUseDomainSelectorScheme) {
    this.symmetricKeyUseDomainSelectorScheme = symmetricKeyUseDomainSelectorScheme;
  }

  public CryptoConfig ownerOrgId(String ownerOrgId) {
    this.ownerOrgId = ownerOrgId;
    return this;
  }

   /**
   * the org id of the organization that owns these symmetric keys
   * @return ownerOrgId
  **/
  @ApiModelProperty(required = true, value = "the org id of the organization that owns these symmetric keys")
  public String getOwnerOrgId() {
    return ownerOrgId;
  }

  public void setOwnerOrgId(String ownerOrgId) {
    this.ownerOrgId = ownerOrgId;
  }

  public CryptoConfig clientKeyType(String clientKeyType) {
    this.clientKeyType = clientKeyType;
    return this;
  }

   /**
   * the type of key that should be associated with clients, for example, rsa
   * @return clientKeyType
  **/
  @ApiModelProperty(required = true, value = "the type of key that should be associated with clients, for example, rsa")
  public String getClientKeyType() {
    return clientKeyType;
  }

  public void setClientKeyType(String clientKeyType) {
    this.clientKeyType = clientKeyType;
  }

  public CryptoConfig clientKeyBitlength(Integer clientKeyBitlength) {
    this.clientKeyBitlength = clientKeyBitlength;
    return this;
  }

   /**
   * the bit length of all new client keys, for example, 2048
   * @return clientKeyBitlength
  **/
  @ApiModelProperty(required = true, value = "the bit length of all new client keys, for example, 2048")
  public Integer getClientKeyBitlength() {
    return clientKeyBitlength;
  }

  public void setClientKeyBitlength(Integer clientKeyBitlength) {
    this.clientKeyBitlength = clientKeyBitlength;
  }

  public CryptoConfig clientKeyTTL(Integer clientKeyTTL) {
    this.clientKeyTTL = clientKeyTTL;
    return this;
  }

   /**
   * the TTL on the client&#39;s local asymetric key
   * @return clientKeyTTL
  **/
  @ApiModelProperty(required = true, value = "the TTL on the client's local asymetric key")
  public Integer getClientKeyTTL() {
    return clientKeyTTL;
  }

  public void setClientKeyTTL(Integer clientKeyTTL) {
    this.clientKeyTTL = clientKeyTTL;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CryptoConfig cryptoConfig = (CryptoConfig) o;
    return Objects.equals(this.id, cryptoConfig.id) &&
        Objects.equals(this.symmetricKeyUseDomains, cryptoConfig.symmetricKeyUseDomains) &&
        Objects.equals(this.symmetricKeyUseDomainSelectorScheme, cryptoConfig.symmetricKeyUseDomainSelectorScheme) &&
        Objects.equals(this.ownerOrgId, cryptoConfig.ownerOrgId) &&
        Objects.equals(this.clientKeyType, cryptoConfig.clientKeyType) &&
        Objects.equals(this.clientKeyBitlength, cryptoConfig.clientKeyBitlength) &&
        Objects.equals(this.clientKeyTTL, cryptoConfig.clientKeyTTL);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, symmetricKeyUseDomains, symmetricKeyUseDomainSelectorScheme, ownerOrgId, clientKeyType, clientKeyBitlength, clientKeyTTL);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CryptoConfig {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    symmetricKeyUseDomains: ").append(toIndentedString(symmetricKeyUseDomains)).append("\n");
    sb.append("    symmetricKeyUseDomainSelectorScheme: ").append(toIndentedString(symmetricKeyUseDomainSelectorScheme)).append("\n");
    sb.append("    ownerOrgId: ").append(toIndentedString(ownerOrgId)).append("\n");
    sb.append("    clientKeyType: ").append(toIndentedString(clientKeyType)).append("\n");
    sb.append("    clientKeyBitlength: ").append(toIndentedString(clientKeyBitlength)).append("\n");
    sb.append("    clientKeyTTL: ").append(toIndentedString(clientKeyTTL)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

