/*
 * Peacemakr
 * This API describes the Peacemakr services, which enable seamless application layer encryption and verification.
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.peacemakr.crypto.swagger.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.peacemakr.crypto.swagger.client.model.PublicKey;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Client
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2020-02-29T21:54:50.815Z")
public class Client {
  @SerializedName("id")
  private String id = null;

  @SerializedName("sdk")
  private String sdk = null;

  @SerializedName("preferredPublicKeyId")
  private String preferredPublicKeyId = null;

  @SerializedName("publicKeys")
  private List<PublicKey> publicKeys = new ArrayList<PublicKey>();

  public Client id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(required = true, value = "")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Client sdk(String sdk) {
    this.sdk = sdk;
    return this;
  }

   /**
   * Get sdk
   * @return sdk
  **/
  @ApiModelProperty(value = "")
  public String getSdk() {
    return sdk;
  }

  public void setSdk(String sdk) {
    this.sdk = sdk;
  }

  public Client preferredPublicKeyId(String preferredPublicKeyId) {
    this.preferredPublicKeyId = preferredPublicKeyId;
    return this;
  }

   /**
   * of all the public keys KeyDeriver&#39;s should deliver to this public key - it is also the most recently added public key
   * @return preferredPublicKeyId
  **/
  @ApiModelProperty(value = "of all the public keys KeyDeriver's should deliver to this public key - it is also the most recently added public key")
  public String getPreferredPublicKeyId() {
    return preferredPublicKeyId;
  }

  public void setPreferredPublicKeyId(String preferredPublicKeyId) {
    this.preferredPublicKeyId = preferredPublicKeyId;
  }

  public Client publicKeys(List<PublicKey> publicKeys) {
    this.publicKeys = publicKeys;
    return this;
  }

  public Client addPublicKeysItem(PublicKey publicKeysItem) {
    this.publicKeys.add(publicKeysItem);
    return this;
  }

   /**
   * Get publicKeys
   * @return publicKeys
  **/
  @ApiModelProperty(required = true, value = "")
  public List<PublicKey> getPublicKeys() {
    return publicKeys;
  }

  public void setPublicKeys(List<PublicKey> publicKeys) {
    this.publicKeys = publicKeys;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Client client = (Client) o;
    return Objects.equals(this.id, client.id) &&
        Objects.equals(this.sdk, client.sdk) &&
        Objects.equals(this.preferredPublicKeyId, client.preferredPublicKeyId) &&
        Objects.equals(this.publicKeys, client.publicKeys);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, sdk, preferredPublicKeyId, publicKeys);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Client {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    sdk: ").append(toIndentedString(sdk)).append("\n");
    sb.append("    preferredPublicKeyId: ").append(toIndentedString(preferredPublicKeyId)).append("\n");
    sb.append("    publicKeys: ").append(toIndentedString(publicKeys)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

