/*
 * Peacemakr
 * This API describes the Peacemakr services, which enable seamless application layer encryption and verification.
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.peacemakr.crypto.swagger.client.api;

import io.peacemakr.crypto.swagger.client.ApiCallback;
import io.peacemakr.crypto.swagger.client.ApiClient;
import io.peacemakr.crypto.swagger.client.ApiException;
import io.peacemakr.crypto.swagger.client.ApiResponse;
import io.peacemakr.crypto.swagger.client.Configuration;
import io.peacemakr.crypto.swagger.client.Pair;
import io.peacemakr.crypto.swagger.client.ProgressRequestBody;
import io.peacemakr.crypto.swagger.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.peacemakr.crypto.swagger.client.model.EncryptedSymmetricKey;
import io.peacemakr.crypto.swagger.client.model.PublicKey;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyServiceApi {
    private ApiClient apiClient;

    public KeyServiceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public KeyServiceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for getAllEncryptedKeys
     * @param encryptingKeyId  (required)
     * @param symmetricKeyIds  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAllEncryptedKeysCall(String encryptingKeyId, List<String> symmetricKeyIds, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/crypto/symmetric/{encryptingKeyId}"
            .replaceAll("\\{" + "encryptingKeyId" + "\\}", apiClient.escapeString(encryptingKeyId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (symmetricKeyIds != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "symmetricKeyIds", symmetricKeyIds));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "header" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAllEncryptedKeysValidateBeforeCall(String encryptingKeyId, List<String> symmetricKeyIds, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'encryptingKeyId' is set
        if (encryptingKeyId == null) {
            throw new ApiException("Missing the required parameter 'encryptingKeyId' when calling getAllEncryptedKeys(Async)");
        }
        

        com.squareup.okhttp.Call call = getAllEncryptedKeysCall(encryptingKeyId, symmetricKeyIds, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get all encrypted symmetric keys that are encrypted with this encrypting keyId, optionally limiting the request to a set of symmetric key domains
     * 
     * @param encryptingKeyId  (required)
     * @param symmetricKeyIds  (optional)
     * @return List&lt;EncryptedSymmetricKey&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<EncryptedSymmetricKey> getAllEncryptedKeys(String encryptingKeyId, List<String> symmetricKeyIds) throws ApiException {
        ApiResponse<List<EncryptedSymmetricKey>> resp = getAllEncryptedKeysWithHttpInfo(encryptingKeyId, symmetricKeyIds);
        return resp.getData();
    }

    /**
     * Get all encrypted symmetric keys that are encrypted with this encrypting keyId, optionally limiting the request to a set of symmetric key domains
     * 
     * @param encryptingKeyId  (required)
     * @param symmetricKeyIds  (optional)
     * @return ApiResponse&lt;List&lt;EncryptedSymmetricKey&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<EncryptedSymmetricKey>> getAllEncryptedKeysWithHttpInfo(String encryptingKeyId, List<String> symmetricKeyIds) throws ApiException {
        com.squareup.okhttp.Call call = getAllEncryptedKeysValidateBeforeCall(encryptingKeyId, symmetricKeyIds, null, null);
        Type localVarReturnType = new TypeToken<List<EncryptedSymmetricKey>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all encrypted symmetric keys that are encrypted with this encrypting keyId, optionally limiting the request to a set of symmetric key domains (asynchronously)
     * 
     * @param encryptingKeyId  (required)
     * @param symmetricKeyIds  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAllEncryptedKeysAsync(String encryptingKeyId, List<String> symmetricKeyIds, final ApiCallback<List<EncryptedSymmetricKey>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAllEncryptedKeysValidateBeforeCall(encryptingKeyId, symmetricKeyIds, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<EncryptedSymmetricKey>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getPublicKey
     * @param keyID  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPublicKeyCall(String keyID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/crypto/asymmetric/{keyID}"
            .replaceAll("\\{" + "keyID" + "\\}", apiClient.escapeString(keyID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "header" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPublicKeyValidateBeforeCall(String keyID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'keyID' is set
        if (keyID == null) {
            throw new ApiException("Missing the required parameter 'keyID' when calling getPublicKey(Async)");
        }
        

        com.squareup.okhttp.Call call = getPublicKeyCall(keyID, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get the public key associated with the passed-in key ID
     * 
     * @param keyID  (required)
     * @return PublicKey
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PublicKey getPublicKey(String keyID) throws ApiException {
        ApiResponse<PublicKey> resp = getPublicKeyWithHttpInfo(keyID);
        return resp.getData();
    }

    /**
     * Get the public key associated with the passed-in key ID
     * 
     * @param keyID  (required)
     * @return ApiResponse&lt;PublicKey&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PublicKey> getPublicKeyWithHttpInfo(String keyID) throws ApiException {
        com.squareup.okhttp.Call call = getPublicKeyValidateBeforeCall(keyID, null, null);
        Type localVarReturnType = new TypeToken<PublicKey>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get the public key associated with the passed-in key ID (asynchronously)
     * 
     * @param keyID  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPublicKeyAsync(String keyID, final ApiCallback<PublicKey> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getPublicKeyValidateBeforeCall(keyID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PublicKey>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for postNewEncryptedKeys
     * @param encryptingKeyId  (required)
     * @param encryptedSymmetricKey  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postNewEncryptedKeysCall(String encryptingKeyId, List<EncryptedSymmetricKey> encryptedSymmetricKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = encryptedSymmetricKey;

        // create path and map variables
        String localVarPath = "/crypto/symmetric/{encryptingKeyId}"
            .replaceAll("\\{" + "encryptingKeyId" + "\\}", apiClient.escapeString(encryptingKeyId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "header" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postNewEncryptedKeysValidateBeforeCall(String encryptingKeyId, List<EncryptedSymmetricKey> encryptedSymmetricKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'encryptingKeyId' is set
        if (encryptingKeyId == null) {
            throw new ApiException("Missing the required parameter 'encryptingKeyId' when calling postNewEncryptedKeys(Async)");
        }
        
        // verify the required parameter 'encryptedSymmetricKey' is set
        if (encryptedSymmetricKey == null) {
            throw new ApiException("Missing the required parameter 'encryptedSymmetricKey' when calling postNewEncryptedKeys(Async)");
        }
        

        com.squareup.okhttp.Call call = postNewEncryptedKeysCall(encryptingKeyId, encryptedSymmetricKey, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add a new encrypted key. The encrypting key that protects the encrypted key is identified with encryptingKeyId. Request must come from a registered key manager.
     * 
     * @param encryptingKeyId  (required)
     * @param encryptedSymmetricKey  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void postNewEncryptedKeys(String encryptingKeyId, List<EncryptedSymmetricKey> encryptedSymmetricKey) throws ApiException {
        postNewEncryptedKeysWithHttpInfo(encryptingKeyId, encryptedSymmetricKey);
    }

    /**
     * Add a new encrypted key. The encrypting key that protects the encrypted key is identified with encryptingKeyId. Request must come from a registered key manager.
     * 
     * @param encryptingKeyId  (required)
     * @param encryptedSymmetricKey  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> postNewEncryptedKeysWithHttpInfo(String encryptingKeyId, List<EncryptedSymmetricKey> encryptedSymmetricKey) throws ApiException {
        com.squareup.okhttp.Call call = postNewEncryptedKeysValidateBeforeCall(encryptingKeyId, encryptedSymmetricKey, null, null);
        return apiClient.execute(call);
    }

    /**
     * Add a new encrypted key. The encrypting key that protects the encrypted key is identified with encryptingKeyId. Request must come from a registered key manager. (asynchronously)
     * 
     * @param encryptingKeyId  (required)
     * @param encryptedSymmetricKey  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postNewEncryptedKeysAsync(String encryptingKeyId, List<EncryptedSymmetricKey> encryptedSymmetricKey, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = postNewEncryptedKeysValidateBeforeCall(encryptingKeyId, encryptedSymmetricKey, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
}
