/*
 * Peacemakr
 * This API describes the Peacemakr services, which enable seamless application layer encryption and verification.
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.peacemakr.crypto.swagger.client.api;

import io.peacemakr.crypto.swagger.client.ApiCallback;
import io.peacemakr.crypto.swagger.client.ApiClient;
import io.peacemakr.crypto.swagger.client.ApiException;
import io.peacemakr.crypto.swagger.client.ApiResponse;
import io.peacemakr.crypto.swagger.client.Configuration;
import io.peacemakr.crypto.swagger.client.Pair;
import io.peacemakr.crypto.swagger.client.ProgressRequestBody;
import io.peacemakr.crypto.swagger.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.peacemakr.crypto.swagger.client.model.HeatbeatResponse;
import io.peacemakr.crypto.swagger.client.model.KeyDerivationInstance;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyDerivationServiceRegistryApi {
    private ApiClient apiClient;

    public KeyDerivationServiceRegistryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public KeyDerivationServiceRegistryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for addKeyDerivationServiceInstance
     * @param keyDerivationInstance  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addKeyDerivationServiceInstanceCall(KeyDerivationInstance keyDerivationInstance, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = keyDerivationInstance;

        // create path and map variables
        String localVarPath = "/crypto/deriver/instance";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "header" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addKeyDerivationServiceInstanceValidateBeforeCall(KeyDerivationInstance keyDerivationInstance, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = addKeyDerivationServiceInstanceCall(keyDerivationInstance, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Register a new KeyDerivationServiceInstance
     * 
     * @param keyDerivationInstance  (optional)
     * @return KeyDerivationInstance
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public KeyDerivationInstance addKeyDerivationServiceInstance(KeyDerivationInstance keyDerivationInstance) throws ApiException {
        ApiResponse<KeyDerivationInstance> resp = addKeyDerivationServiceInstanceWithHttpInfo(keyDerivationInstance);
        return resp.getData();
    }

    /**
     * Register a new KeyDerivationServiceInstance
     * 
     * @param keyDerivationInstance  (optional)
     * @return ApiResponse&lt;KeyDerivationInstance&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<KeyDerivationInstance> addKeyDerivationServiceInstanceWithHttpInfo(KeyDerivationInstance keyDerivationInstance) throws ApiException {
        com.squareup.okhttp.Call call = addKeyDerivationServiceInstanceValidateBeforeCall(keyDerivationInstance, null, null);
        Type localVarReturnType = new TypeToken<KeyDerivationInstance>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Register a new KeyDerivationServiceInstance (asynchronously)
     * 
     * @param keyDerivationInstance  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call addKeyDerivationServiceInstanceAsync(KeyDerivationInstance keyDerivationInstance, final ApiCallback<KeyDerivationInstance> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = addKeyDerivationServiceInstanceValidateBeforeCall(keyDerivationInstance, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<KeyDerivationInstance>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteKeyDerivationServiceInstance
     * @param keyDerivationInstanceId  (required)
     * @param active  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteKeyDerivationServiceInstanceCall(String keyDerivationInstanceId, String active, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/crypto/deriver/instance/{keyDerivationInstanceId}"
            .replaceAll("\\{" + "keyDerivationInstanceId" + "\\}", apiClient.escapeString(keyDerivationInstanceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (active != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("active", active));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "header" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteKeyDerivationServiceInstanceValidateBeforeCall(String keyDerivationInstanceId, String active, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'keyDerivationInstanceId' is set
        if (keyDerivationInstanceId == null) {
            throw new ApiException("Missing the required parameter 'keyDerivationInstanceId' when calling deleteKeyDerivationServiceInstance(Async)");
        }
        
        // verify the required parameter 'active' is set
        if (active == null) {
            throw new ApiException("Missing the required parameter 'active' when calling deleteKeyDerivationServiceInstance(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteKeyDerivationServiceInstanceCall(keyDerivationInstanceId, active, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Activate or deactivate an existing KeyDerivationServiceInstance
     * 
     * @param keyDerivationInstanceId  (required)
     * @param active  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteKeyDerivationServiceInstance(String keyDerivationInstanceId, String active) throws ApiException {
        deleteKeyDerivationServiceInstanceWithHttpInfo(keyDerivationInstanceId, active);
    }

    /**
     * Activate or deactivate an existing KeyDerivationServiceInstance
     * 
     * @param keyDerivationInstanceId  (required)
     * @param active  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteKeyDerivationServiceInstanceWithHttpInfo(String keyDerivationInstanceId, String active) throws ApiException {
        com.squareup.okhttp.Call call = deleteKeyDerivationServiceInstanceValidateBeforeCall(keyDerivationInstanceId, active, null, null);
        return apiClient.execute(call);
    }

    /**
     * Activate or deactivate an existing KeyDerivationServiceInstance (asynchronously)
     * 
     * @param keyDerivationInstanceId  (required)
     * @param active  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteKeyDerivationServiceInstanceAsync(String keyDerivationInstanceId, String active, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteKeyDerivationServiceInstanceValidateBeforeCall(keyDerivationInstanceId, active, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for getAllOrgKeyDerivationServiceInstances
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAllOrgKeyDerivationServiceInstancesCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/crypto/deriver/all-org-instances";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "header" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAllOrgKeyDerivationServiceInstancesValidateBeforeCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = getAllOrgKeyDerivationServiceInstancesCall(progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get the all key derivers registerd to org
     * 
     * @return List&lt;KeyDerivationInstance&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<KeyDerivationInstance> getAllOrgKeyDerivationServiceInstances() throws ApiException {
        ApiResponse<List<KeyDerivationInstance>> resp = getAllOrgKeyDerivationServiceInstancesWithHttpInfo();
        return resp.getData();
    }

    /**
     * Get the all key derivers registerd to org
     * 
     * @return ApiResponse&lt;List&lt;KeyDerivationInstance&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<KeyDerivationInstance>> getAllOrgKeyDerivationServiceInstancesWithHttpInfo() throws ApiException {
        com.squareup.okhttp.Call call = getAllOrgKeyDerivationServiceInstancesValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<List<KeyDerivationInstance>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get the all key derivers registerd to org (asynchronously)
     * 
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAllOrgKeyDerivationServiceInstancesAsync(final ApiCallback<List<KeyDerivationInstance>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAllOrgKeyDerivationServiceInstancesValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<KeyDerivationInstance>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getAllSharedKeyDerivationServiceInstances
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAllSharedKeyDerivationServiceInstancesCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/crypto/deriver/all-shared-instances";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "header" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAllSharedKeyDerivationServiceInstancesValidateBeforeCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = getAllSharedKeyDerivationServiceInstancesCall(progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get the all key derivers that the org has access to - including shared cloud instances
     * 
     * @return List&lt;KeyDerivationInstance&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<KeyDerivationInstance> getAllSharedKeyDerivationServiceInstances() throws ApiException {
        ApiResponse<List<KeyDerivationInstance>> resp = getAllSharedKeyDerivationServiceInstancesWithHttpInfo();
        return resp.getData();
    }

    /**
     * Get the all key derivers that the org has access to - including shared cloud instances
     * 
     * @return ApiResponse&lt;List&lt;KeyDerivationInstance&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<KeyDerivationInstance>> getAllSharedKeyDerivationServiceInstancesWithHttpInfo() throws ApiException {
        com.squareup.okhttp.Call call = getAllSharedKeyDerivationServiceInstancesValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<List<KeyDerivationInstance>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get the all key derivers that the org has access to - including shared cloud instances (asynchronously)
     * 
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAllSharedKeyDerivationServiceInstancesAsync(final ApiCallback<List<KeyDerivationInstance>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAllSharedKeyDerivationServiceInstancesValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<KeyDerivationInstance>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getKeyDerivationServiceInstance
     * @param keyDerivationInstanceId  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getKeyDerivationServiceInstanceCall(String keyDerivationInstanceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/crypto/deriver/instance/{keyDerivationInstanceId}"
            .replaceAll("\\{" + "keyDerivationInstanceId" + "\\}", apiClient.escapeString(keyDerivationInstanceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "header" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getKeyDerivationServiceInstanceValidateBeforeCall(String keyDerivationInstanceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'keyDerivationInstanceId' is set
        if (keyDerivationInstanceId == null) {
            throw new ApiException("Missing the required parameter 'keyDerivationInstanceId' when calling getKeyDerivationServiceInstance(Async)");
        }
        

        com.squareup.okhttp.Call call = getKeyDerivationServiceInstanceCall(keyDerivationInstanceId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get the keyderiver details by id
     * 
     * @param keyDerivationInstanceId  (required)
     * @return KeyDerivationInstance
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public KeyDerivationInstance getKeyDerivationServiceInstance(String keyDerivationInstanceId) throws ApiException {
        ApiResponse<KeyDerivationInstance> resp = getKeyDerivationServiceInstanceWithHttpInfo(keyDerivationInstanceId);
        return resp.getData();
    }

    /**
     * Get the keyderiver details by id
     * 
     * @param keyDerivationInstanceId  (required)
     * @return ApiResponse&lt;KeyDerivationInstance&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<KeyDerivationInstance> getKeyDerivationServiceInstanceWithHttpInfo(String keyDerivationInstanceId) throws ApiException {
        com.squareup.okhttp.Call call = getKeyDerivationServiceInstanceValidateBeforeCall(keyDerivationInstanceId, null, null);
        Type localVarReturnType = new TypeToken<KeyDerivationInstance>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get the keyderiver details by id (asynchronously)
     * 
     * @param keyDerivationInstanceId  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getKeyDerivationServiceInstanceAsync(String keyDerivationInstanceId, final ApiCallback<KeyDerivationInstance> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getKeyDerivationServiceInstanceValidateBeforeCall(keyDerivationInstanceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<KeyDerivationInstance>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for heartbeatKeyDerivationServiceInstance
     * @param keyDerivationInstanceId  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call heartbeatKeyDerivationServiceInstanceCall(String keyDerivationInstanceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/crypto/deriver/instance/{keyDerivationInstanceId}/heartbeat"
            .replaceAll("\\{" + "keyDerivationInstanceId" + "\\}", apiClient.escapeString(keyDerivationInstanceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "header" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call heartbeatKeyDerivationServiceInstanceValidateBeforeCall(String keyDerivationInstanceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'keyDerivationInstanceId' is set
        if (keyDerivationInstanceId == null) {
            throw new ApiException("Missing the required parameter 'keyDerivationInstanceId' when calling heartbeatKeyDerivationServiceInstance(Async)");
        }
        

        com.squareup.okhttp.Call call = heartbeatKeyDerivationServiceInstanceCall(keyDerivationInstanceId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Heatbeat from the given key derivation service instance
     * 
     * @param keyDerivationInstanceId  (required)
     * @return HeatbeatResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public HeatbeatResponse heartbeatKeyDerivationServiceInstance(String keyDerivationInstanceId) throws ApiException {
        ApiResponse<HeatbeatResponse> resp = heartbeatKeyDerivationServiceInstanceWithHttpInfo(keyDerivationInstanceId);
        return resp.getData();
    }

    /**
     * Heatbeat from the given key derivation service instance
     * 
     * @param keyDerivationInstanceId  (required)
     * @return ApiResponse&lt;HeatbeatResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<HeatbeatResponse> heartbeatKeyDerivationServiceInstanceWithHttpInfo(String keyDerivationInstanceId) throws ApiException {
        com.squareup.okhttp.Call call = heartbeatKeyDerivationServiceInstanceValidateBeforeCall(keyDerivationInstanceId, null, null);
        Type localVarReturnType = new TypeToken<HeatbeatResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Heatbeat from the given key derivation service instance (asynchronously)
     * 
     * @param keyDerivationInstanceId  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call heartbeatKeyDerivationServiceInstanceAsync(String keyDerivationInstanceId, final ApiCallback<HeatbeatResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = heartbeatKeyDerivationServiceInstanceValidateBeforeCall(keyDerivationInstanceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<HeatbeatResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
