/*
 * Peacemakr
 * This API describes the Peacemakr services, which enable seamless application layer encryption and verification.
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.peacemakr.crypto.swagger.client.api;

import io.peacemakr.crypto.swagger.client.ApiCallback;
import io.peacemakr.crypto.swagger.client.ApiClient;
import io.peacemakr.crypto.swagger.client.ApiException;
import io.peacemakr.crypto.swagger.client.ApiResponse;
import io.peacemakr.crypto.swagger.client.Configuration;
import io.peacemakr.crypto.swagger.client.Pair;
import io.peacemakr.crypto.swagger.client.ProgressRequestBody;
import io.peacemakr.crypto.swagger.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.peacemakr.crypto.swagger.client.model.CryptoConfig;
import io.peacemakr.crypto.swagger.client.model.ErrorResponse;
import io.peacemakr.crypto.swagger.client.model.SymmetricKeyUseDomain;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CryptoConfigApi {
    private ApiClient apiClient;

    public CryptoConfigApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CryptoConfigApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for addExistingUseDomain
     * @param cryptoConfigId  (required)
     * @param useDomainId  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addExistingUseDomainCall(String cryptoConfigId, String useDomainId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/crypto/config/{cryptoConfigId}/useDomain/{useDomainId}"
            .replaceAll("\\{" + "cryptoConfigId" + "\\}", apiClient.escapeString(cryptoConfigId.toString()))
            .replaceAll("\\{" + "useDomainId" + "\\}", apiClient.escapeString(useDomainId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "header" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addExistingUseDomainValidateBeforeCall(String cryptoConfigId, String useDomainId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'cryptoConfigId' is set
        if (cryptoConfigId == null) {
            throw new ApiException("Missing the required parameter 'cryptoConfigId' when calling addExistingUseDomain(Async)");
        }
        
        // verify the required parameter 'useDomainId' is set
        if (useDomainId == null) {
            throw new ApiException("Missing the required parameter 'useDomainId' when calling addExistingUseDomain(Async)");
        }
        

        com.squareup.okhttp.Call call = addExistingUseDomainCall(cryptoConfigId, useDomainId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add an existing use domain to another crypto config.
     * 
     * @param cryptoConfigId  (required)
     * @param useDomainId  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void addExistingUseDomain(String cryptoConfigId, String useDomainId) throws ApiException {
        addExistingUseDomainWithHttpInfo(cryptoConfigId, useDomainId);
    }

    /**
     * Add an existing use domain to another crypto config.
     * 
     * @param cryptoConfigId  (required)
     * @param useDomainId  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> addExistingUseDomainWithHttpInfo(String cryptoConfigId, String useDomainId) throws ApiException {
        com.squareup.okhttp.Call call = addExistingUseDomainValidateBeforeCall(cryptoConfigId, useDomainId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Add an existing use domain to another crypto config. (asynchronously)
     * 
     * @param cryptoConfigId  (required)
     * @param useDomainId  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call addExistingUseDomainAsync(String cryptoConfigId, String useDomainId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = addExistingUseDomainValidateBeforeCall(cryptoConfigId, useDomainId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for addUseDomain
     * @param cryptoConfigId  (required)
     * @param newUseDomain  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addUseDomainCall(String cryptoConfigId, SymmetricKeyUseDomain newUseDomain, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = newUseDomain;

        // create path and map variables
        String localVarPath = "/crypto/config/{cryptoConfigId}/useDomain"
            .replaceAll("\\{" + "cryptoConfigId" + "\\}", apiClient.escapeString(cryptoConfigId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "header" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addUseDomainValidateBeforeCall(String cryptoConfigId, SymmetricKeyUseDomain newUseDomain, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'cryptoConfigId' is set
        if (cryptoConfigId == null) {
            throw new ApiException("Missing the required parameter 'cryptoConfigId' when calling addUseDomain(Async)");
        }
        
        // verify the required parameter 'newUseDomain' is set
        if (newUseDomain == null) {
            throw new ApiException("Missing the required parameter 'newUseDomain' when calling addUseDomain(Async)");
        }
        

        com.squareup.okhttp.Call call = addUseDomainCall(cryptoConfigId, newUseDomain, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add a new active use domain and attached it to the crypto config.
     * 
     * @param cryptoConfigId  (required)
     * @param newUseDomain  (required)
     * @return SymmetricKeyUseDomain
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public SymmetricKeyUseDomain addUseDomain(String cryptoConfigId, SymmetricKeyUseDomain newUseDomain) throws ApiException {
        ApiResponse<SymmetricKeyUseDomain> resp = addUseDomainWithHttpInfo(cryptoConfigId, newUseDomain);
        return resp.getData();
    }

    /**
     * Add a new active use domain and attached it to the crypto config.
     * 
     * @param cryptoConfigId  (required)
     * @param newUseDomain  (required)
     * @return ApiResponse&lt;SymmetricKeyUseDomain&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<SymmetricKeyUseDomain> addUseDomainWithHttpInfo(String cryptoConfigId, SymmetricKeyUseDomain newUseDomain) throws ApiException {
        com.squareup.okhttp.Call call = addUseDomainValidateBeforeCall(cryptoConfigId, newUseDomain, null, null);
        Type localVarReturnType = new TypeToken<SymmetricKeyUseDomain>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Add a new active use domain and attached it to the crypto config. (asynchronously)
     * 
     * @param cryptoConfigId  (required)
     * @param newUseDomain  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call addUseDomainAsync(String cryptoConfigId, SymmetricKeyUseDomain newUseDomain, final ApiCallback<SymmetricKeyUseDomain> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = addUseDomainValidateBeforeCall(cryptoConfigId, newUseDomain, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SymmetricKeyUseDomain>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getCryptoConfig
     * @param cryptoConfigId  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCryptoConfigCall(String cryptoConfigId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/crypto/config/{cryptoConfigId}"
            .replaceAll("\\{" + "cryptoConfigId" + "\\}", apiClient.escapeString(cryptoConfigId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "header" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCryptoConfigValidateBeforeCall(String cryptoConfigId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'cryptoConfigId' is set
        if (cryptoConfigId == null) {
            throw new ApiException("Missing the required parameter 'cryptoConfigId' when calling getCryptoConfig(Async)");
        }
        

        com.squareup.okhttp.Call call = getCryptoConfigCall(cryptoConfigId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get the crypto configurations
     * 
     * @param cryptoConfigId  (required)
     * @return CryptoConfig
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CryptoConfig getCryptoConfig(String cryptoConfigId) throws ApiException {
        ApiResponse<CryptoConfig> resp = getCryptoConfigWithHttpInfo(cryptoConfigId);
        return resp.getData();
    }

    /**
     * Get the crypto configurations
     * 
     * @param cryptoConfigId  (required)
     * @return ApiResponse&lt;CryptoConfig&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CryptoConfig> getCryptoConfigWithHttpInfo(String cryptoConfigId) throws ApiException {
        com.squareup.okhttp.Call call = getCryptoConfigValidateBeforeCall(cryptoConfigId, null, null);
        Type localVarReturnType = new TypeToken<CryptoConfig>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get the crypto configurations (asynchronously)
     * 
     * @param cryptoConfigId  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getCryptoConfigAsync(String cryptoConfigId, final ApiCallback<CryptoConfig> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getCryptoConfigValidateBeforeCall(cryptoConfigId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CryptoConfig>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for rapidRotationUseDomain
     * @param useDomainId  (required)
     * @param optionalNextKeyDerivationServiceId  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call rapidRotationUseDomainCall(String useDomainId, String optionalNextKeyDerivationServiceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/crypto/useDomain/{useDomainId}/rapidRotation"
            .replaceAll("\\{" + "useDomainId" + "\\}", apiClient.escapeString(useDomainId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (optionalNextKeyDerivationServiceId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("optionalNextKeyDerivationServiceId", optionalNextKeyDerivationServiceId));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "header" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call rapidRotationUseDomainValidateBeforeCall(String useDomainId, String optionalNextKeyDerivationServiceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'useDomainId' is set
        if (useDomainId == null) {
            throw new ApiException("Missing the required parameter 'useDomainId' when calling rapidRotationUseDomain(Async)");
        }
        

        com.squareup.okhttp.Call call = rapidRotationUseDomainCall(useDomainId, optionalNextKeyDerivationServiceId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Rapid expiration of existing use doamin and immediately replacment with an identical use domain containing fresh keys
     * 
     * @param useDomainId  (required)
     * @param optionalNextKeyDerivationServiceId  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void rapidRotationUseDomain(String useDomainId, String optionalNextKeyDerivationServiceId) throws ApiException {
        rapidRotationUseDomainWithHttpInfo(useDomainId, optionalNextKeyDerivationServiceId);
    }

    /**
     * Rapid expiration of existing use doamin and immediately replacment with an identical use domain containing fresh keys
     * 
     * @param useDomainId  (required)
     * @param optionalNextKeyDerivationServiceId  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> rapidRotationUseDomainWithHttpInfo(String useDomainId, String optionalNextKeyDerivationServiceId) throws ApiException {
        com.squareup.okhttp.Call call = rapidRotationUseDomainValidateBeforeCall(useDomainId, optionalNextKeyDerivationServiceId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Rapid expiration of existing use doamin and immediately replacment with an identical use domain containing fresh keys (asynchronously)
     * 
     * @param useDomainId  (required)
     * @param optionalNextKeyDerivationServiceId  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call rapidRotationUseDomainAsync(String useDomainId, String optionalNextKeyDerivationServiceId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = rapidRotationUseDomainValidateBeforeCall(useDomainId, optionalNextKeyDerivationServiceId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for removeUseDomain
     * @param useDomainId  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call removeUseDomainCall(String useDomainId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/crypto/useDomain/{useDomainId}"
            .replaceAll("\\{" + "useDomainId" + "\\}", apiClient.escapeString(useDomainId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "header" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call removeUseDomainValidateBeforeCall(String useDomainId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'useDomainId' is set
        if (useDomainId == null) {
            throw new ApiException("Missing the required parameter 'useDomainId' when calling removeUseDomain(Async)");
        }
        

        com.squareup.okhttp.Call call = removeUseDomainCall(useDomainId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a fully expired use domain
     * 
     * @param useDomainId  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void removeUseDomain(String useDomainId) throws ApiException {
        removeUseDomainWithHttpInfo(useDomainId);
    }

    /**
     * Delete a fully expired use domain
     * 
     * @param useDomainId  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> removeUseDomainWithHttpInfo(String useDomainId) throws ApiException {
        com.squareup.okhttp.Call call = removeUseDomainValidateBeforeCall(useDomainId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a fully expired use domain (asynchronously)
     * 
     * @param useDomainId  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call removeUseDomainAsync(String useDomainId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = removeUseDomainValidateBeforeCall(useDomainId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for updateCryptoConfig
     * @param cryptoConfigId  (required)
     * @param updatedCryptoConfig  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateCryptoConfigCall(String cryptoConfigId, CryptoConfig updatedCryptoConfig, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = updatedCryptoConfig;

        // create path and map variables
        String localVarPath = "/crypto/config/{cryptoConfigId}"
            .replaceAll("\\{" + "cryptoConfigId" + "\\}", apiClient.escapeString(cryptoConfigId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "header" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateCryptoConfigValidateBeforeCall(String cryptoConfigId, CryptoConfig updatedCryptoConfig, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'cryptoConfigId' is set
        if (cryptoConfigId == null) {
            throw new ApiException("Missing the required parameter 'cryptoConfigId' when calling updateCryptoConfig(Async)");
        }
        
        // verify the required parameter 'updatedCryptoConfig' is set
        if (updatedCryptoConfig == null) {
            throw new ApiException("Missing the required parameter 'updatedCryptoConfig' when calling updateCryptoConfig(Async)");
        }
        

        com.squareup.okhttp.Call call = updateCryptoConfigCall(cryptoConfigId, updatedCryptoConfig, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Update the crypto configuration, ONLY the clientKeyType clientKeyBitlength, and clientKeyTTL fields.
     * 
     * @param cryptoConfigId  (required)
     * @param updatedCryptoConfig  (required)
     * @return CryptoConfig
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CryptoConfig updateCryptoConfig(String cryptoConfigId, CryptoConfig updatedCryptoConfig) throws ApiException {
        ApiResponse<CryptoConfig> resp = updateCryptoConfigWithHttpInfo(cryptoConfigId, updatedCryptoConfig);
        return resp.getData();
    }

    /**
     * Update the crypto configuration, ONLY the clientKeyType clientKeyBitlength, and clientKeyTTL fields.
     * 
     * @param cryptoConfigId  (required)
     * @param updatedCryptoConfig  (required)
     * @return ApiResponse&lt;CryptoConfig&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CryptoConfig> updateCryptoConfigWithHttpInfo(String cryptoConfigId, CryptoConfig updatedCryptoConfig) throws ApiException {
        com.squareup.okhttp.Call call = updateCryptoConfigValidateBeforeCall(cryptoConfigId, updatedCryptoConfig, null, null);
        Type localVarReturnType = new TypeToken<CryptoConfig>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update the crypto configuration, ONLY the clientKeyType clientKeyBitlength, and clientKeyTTL fields. (asynchronously)
     * 
     * @param cryptoConfigId  (required)
     * @param updatedCryptoConfig  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateCryptoConfigAsync(String cryptoConfigId, CryptoConfig updatedCryptoConfig, final ApiCallback<CryptoConfig> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updateCryptoConfigValidateBeforeCall(cryptoConfigId, updatedCryptoConfig, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CryptoConfig>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for updateCryptoConfigFallbackToCloud
     * @param useDomainId  (required)
     * @param fallbackToCloud  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateCryptoConfigFallbackToCloudCall(String useDomainId, Boolean fallbackToCloud, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/crypto/useDomain/{useDomainId}/enableKDSFallbackToCloud"
            .replaceAll("\\{" + "useDomainId" + "\\}", apiClient.escapeString(useDomainId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (fallbackToCloud != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("fallbackToCloud", fallbackToCloud));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "header" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateCryptoConfigFallbackToCloudValidateBeforeCall(String useDomainId, Boolean fallbackToCloud, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'useDomainId' is set
        if (useDomainId == null) {
            throw new ApiException("Missing the required parameter 'useDomainId' when calling updateCryptoConfigFallbackToCloud(Async)");
        }
        
        // verify the required parameter 'fallbackToCloud' is set
        if (fallbackToCloud == null) {
            throw new ApiException("Missing the required parameter 'fallbackToCloud' when calling updateCryptoConfigFallbackToCloud(Async)");
        }
        

        com.squareup.okhttp.Call call = updateCryptoConfigFallbackToCloudCall(useDomainId, fallbackToCloud, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Update an existing crypto config&#39;s asymmetricKeyTTL
     * 
     * @param useDomainId  (required)
     * @param fallbackToCloud  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void updateCryptoConfigFallbackToCloud(String useDomainId, Boolean fallbackToCloud) throws ApiException {
        updateCryptoConfigFallbackToCloudWithHttpInfo(useDomainId, fallbackToCloud);
    }

    /**
     * Update an existing crypto config&#39;s asymmetricKeyTTL
     * 
     * @param useDomainId  (required)
     * @param fallbackToCloud  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> updateCryptoConfigFallbackToCloudWithHttpInfo(String useDomainId, Boolean fallbackToCloud) throws ApiException {
        com.squareup.okhttp.Call call = updateCryptoConfigFallbackToCloudValidateBeforeCall(useDomainId, fallbackToCloud, null, null);
        return apiClient.execute(call);
    }

    /**
     * Update an existing crypto config&#39;s asymmetricKeyTTL (asynchronously)
     * 
     * @param useDomainId  (required)
     * @param fallbackToCloud  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateCryptoConfigFallbackToCloudAsync(String useDomainId, Boolean fallbackToCloud, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updateCryptoConfigFallbackToCloudValidateBeforeCall(useDomainId, fallbackToCloud, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for updateCryptoConfigSelectorScheme
     * @param cryptoConfigId  (required)
     * @param newSelectorScheme  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateCryptoConfigSelectorSchemeCall(String cryptoConfigId, String newSelectorScheme, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/crypto/config/{cryptoConfigId}/domainSelectorScheme"
            .replaceAll("\\{" + "cryptoConfigId" + "\\}", apiClient.escapeString(cryptoConfigId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (newSelectorScheme != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("newSelectorScheme", newSelectorScheme));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "header" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateCryptoConfigSelectorSchemeValidateBeforeCall(String cryptoConfigId, String newSelectorScheme, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'cryptoConfigId' is set
        if (cryptoConfigId == null) {
            throw new ApiException("Missing the required parameter 'cryptoConfigId' when calling updateCryptoConfigSelectorScheme(Async)");
        }
        
        // verify the required parameter 'newSelectorScheme' is set
        if (newSelectorScheme == null) {
            throw new ApiException("Missing the required parameter 'newSelectorScheme' when calling updateCryptoConfigSelectorScheme(Async)");
        }
        

        com.squareup.okhttp.Call call = updateCryptoConfigSelectorSchemeCall(cryptoConfigId, newSelectorScheme, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Update an existing crypto config&#39;s domainSelectorScheme
     * 
     * @param cryptoConfigId  (required)
     * @param newSelectorScheme  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void updateCryptoConfigSelectorScheme(String cryptoConfigId, String newSelectorScheme) throws ApiException {
        updateCryptoConfigSelectorSchemeWithHttpInfo(cryptoConfigId, newSelectorScheme);
    }

    /**
     * Update an existing crypto config&#39;s domainSelectorScheme
     * 
     * @param cryptoConfigId  (required)
     * @param newSelectorScheme  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> updateCryptoConfigSelectorSchemeWithHttpInfo(String cryptoConfigId, String newSelectorScheme) throws ApiException {
        com.squareup.okhttp.Call call = updateCryptoConfigSelectorSchemeValidateBeforeCall(cryptoConfigId, newSelectorScheme, null, null);
        return apiClient.execute(call);
    }

    /**
     * Update an existing crypto config&#39;s domainSelectorScheme (asynchronously)
     * 
     * @param cryptoConfigId  (required)
     * @param newSelectorScheme  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateCryptoConfigSelectorSchemeAsync(String cryptoConfigId, String newSelectorScheme, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updateCryptoConfigSelectorSchemeValidateBeforeCall(cryptoConfigId, newSelectorScheme, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for updateExpireUseDomain
     * @param useDomainId  (required)
     * @param inceptionTTL  (required)
     * @param encryptionTTL  (required)
     * @param decryptionTTL  (required)
     * @param retentionTTL  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateExpireUseDomainCall(String useDomainId, Integer inceptionTTL, Integer encryptionTTL, Integer decryptionTTL, Integer retentionTTL, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/crypto/useDomain/{useDomainId}/updateExpire"
            .replaceAll("\\{" + "useDomainId" + "\\}", apiClient.escapeString(useDomainId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inceptionTTL != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("inceptionTTL", inceptionTTL));
        if (encryptionTTL != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("encryptionTTL", encryptionTTL));
        if (decryptionTTL != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("decryptionTTL", decryptionTTL));
        if (retentionTTL != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("retentionTTL", retentionTTL));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "header" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateExpireUseDomainValidateBeforeCall(String useDomainId, Integer inceptionTTL, Integer encryptionTTL, Integer decryptionTTL, Integer retentionTTL, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'useDomainId' is set
        if (useDomainId == null) {
            throw new ApiException("Missing the required parameter 'useDomainId' when calling updateExpireUseDomain(Async)");
        }
        
        // verify the required parameter 'inceptionTTL' is set
        if (inceptionTTL == null) {
            throw new ApiException("Missing the required parameter 'inceptionTTL' when calling updateExpireUseDomain(Async)");
        }
        
        // verify the required parameter 'encryptionTTL' is set
        if (encryptionTTL == null) {
            throw new ApiException("Missing the required parameter 'encryptionTTL' when calling updateExpireUseDomain(Async)");
        }
        
        // verify the required parameter 'decryptionTTL' is set
        if (decryptionTTL == null) {
            throw new ApiException("Missing the required parameter 'decryptionTTL' when calling updateExpireUseDomain(Async)");
        }
        
        // verify the required parameter 'retentionTTL' is set
        if (retentionTTL == null) {
            throw new ApiException("Missing the required parameter 'retentionTTL' when calling updateExpireUseDomain(Async)");
        }
        

        com.squareup.okhttp.Call call = updateExpireUseDomainCall(useDomainId, inceptionTTL, encryptionTTL, decryptionTTL, retentionTTL, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Chnage expiration of a use domain
     * 
     * @param useDomainId  (required)
     * @param inceptionTTL  (required)
     * @param encryptionTTL  (required)
     * @param decryptionTTL  (required)
     * @param retentionTTL  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void updateExpireUseDomain(String useDomainId, Integer inceptionTTL, Integer encryptionTTL, Integer decryptionTTL, Integer retentionTTL) throws ApiException {
        updateExpireUseDomainWithHttpInfo(useDomainId, inceptionTTL, encryptionTTL, decryptionTTL, retentionTTL);
    }

    /**
     * Chnage expiration of a use domain
     * 
     * @param useDomainId  (required)
     * @param inceptionTTL  (required)
     * @param encryptionTTL  (required)
     * @param decryptionTTL  (required)
     * @param retentionTTL  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> updateExpireUseDomainWithHttpInfo(String useDomainId, Integer inceptionTTL, Integer encryptionTTL, Integer decryptionTTL, Integer retentionTTL) throws ApiException {
        com.squareup.okhttp.Call call = updateExpireUseDomainValidateBeforeCall(useDomainId, inceptionTTL, encryptionTTL, decryptionTTL, retentionTTL, null, null);
        return apiClient.execute(call);
    }

    /**
     * Chnage expiration of a use domain (asynchronously)
     * 
     * @param useDomainId  (required)
     * @param inceptionTTL  (required)
     * @param encryptionTTL  (required)
     * @param decryptionTTL  (required)
     * @param retentionTTL  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateExpireUseDomainAsync(String useDomainId, Integer inceptionTTL, Integer encryptionTTL, Integer decryptionTTL, Integer retentionTTL, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updateExpireUseDomainValidateBeforeCall(useDomainId, inceptionTTL, encryptionTTL, decryptionTTL, retentionTTL, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
}
