/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.core.validation.operand.arithmetical;

import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.operand.arithmetical.ASTOperandArithmeticalItemBase;
import io.openvalidation.common.ast.operand.arithmetical.ASTOperandArithmeticalOperation;
import io.openvalidation.common.exceptions.ASTValidationException;
import io.openvalidation.common.utils.LINQ;
import io.openvalidation.core.validation.ValidatorBase;
import io.openvalidation.core.validation.ValidatorFactory;
import java.util.List;

public class ASTArithmeticalOperationValidator
extends ValidatorBase {
    private ASTOperandArithmeticalOperation _arithmeticalOperation;

    public ASTArithmeticalOperationValidator(ASTOperandArithmeticalOperation arithmeticalOperation) {
        this._arithmeticalOperation = arithmeticalOperation;
    }

    @Override
    public void validate() throws Exception {
        List items = this._arithmeticalOperation.getItems();
        List itemsWithValues = LINQ.where((List)items, i -> i.getOperand() != null || i instanceof ASTOperandArithmeticalOperation && ((ASTOperandArithmeticalOperation)i).getItems() != null);
        if (itemsWithValues.size() < 1) {
            throw new ASTValidationException("missing all values in arithmetical operation", (ASTItem)this._arithmeticalOperation, this.globalPosition);
        }
        if (items.size() < 2 || itemsWithValues.size() < items.size()) {
            throw new ASTValidationException("missing value in arithmetical operation", (ASTItem)this._arithmeticalOperation, this.globalPosition);
        }
        if (LINQ.count((List)itemsWithValues, i -> i.isNumber()) < items.size()) {
            throw new ASTValidationException("all values of an arithmetical operation should be numbers", (ASTItem)this._arithmeticalOperation, this.globalPosition);
        }
        boolean first = true;
        for (ASTOperandArithmeticalItemBase i2 : items) {
            if (first) {
                first = false;
            } else if (i2.getOperator() == null) {
                throw new ASTValidationException("missing arithmetical operator.", (ASTItem)i2, this.globalPosition);
            }
            ValidatorBase validator = ValidatorFactory.Create((ASTItem)i2);
            validator.validate();
        }
    }
}

