/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.core.validation.functions;

import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.ASTOperandFunction;
import io.openvalidation.common.ast.operand.ASTOperandVariable;
import io.openvalidation.common.ast.operand.lambda.ASTOperandLambdaCondition;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.exceptions.ASTValidationException;
import io.openvalidation.common.utils.StringUtils;
import io.openvalidation.core.validation.functions.FunctionValidatorBase;
import java.util.List;

public class FunctionWhereValidator
extends FunctionValidatorBase {
    public FunctionWhereValidator(ASTOperandFunction function) {
        this.function = function;
    }

    @Override
    public void validateFunction() throws Exception {
        List parameters = this.function.getParameters();
        if (parameters.size() < 2) {
            throw new ASTValidationException("Invalid number of parameters. The function " + this.function.getName() + "needs 2 parameters but has" + parameters.size() + ". The first has to be a " + StringUtils.getUserFriendlyClassName(ASTOperandProperty.class) + "/" + StringUtils.getUserFriendlyClassName(ASTOperandVariable.class) + " of type Array and the second a " + StringUtils.getUserFriendlyClassName(ASTOperandLambdaCondition.class) + ".", (ASTItem)this.function);
        }
        ASTOperandBase firstParam = (ASTOperandBase)parameters.get(0);
        String firstParamClassName = StringUtils.getUserFriendlyClassName((Object)firstParam);
        if (!(firstParam instanceof ASTOperandProperty || firstParam instanceof ASTOperandFunction || firstParam instanceof ASTOperandVariable)) {
            throw new ASTValidationException("The first parameter of the function " + this.function.getName() + " has to be an array property or a nested function. Currently applied on " + firstParamClassName, (ASTItem)this.function);
        }
        if (firstParam.getDataType() != DataPropertyType.Array) {
            throw new ASTValidationException("The first parameter (" + firstParamClassName + ") of " + this.function.getName() + " has to be of type 'Array'. Type found: " + firstParam.getDataType() + ".", (ASTItem)this.function);
        }
        ASTOperandBase secondParam = (ASTOperandBase)parameters.get(1);
        String secondParamClassName = StringUtils.getUserFriendlyClassName((Object)secondParam);
        if (!(secondParam instanceof ASTOperandLambdaCondition)) {
            throw new ASTValidationException("The second parameter of the function " + this.function.getName() + " has to be a condition. Found: " + secondParamClassName, (ASTItem)this.function);
        }
    }
}

