/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.core.validation.functions;

import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.ASTOperandFunction;
import io.openvalidation.common.ast.operand.ASTOperandStaticNumber;
import io.openvalidation.common.ast.operand.ASTOperandVariable;
import io.openvalidation.common.ast.operand.lambda.ASTOperandLambdaCondition;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.exceptions.ASTValidationException;
import io.openvalidation.core.validation.functions.FunctionValidatorBase;
import java.util.List;

public class FunctionTakeValidator
extends FunctionValidatorBase {
    public FunctionTakeValidator(ASTOperandFunction function) {
        this.function = function;
    }

    @Override
    public void validateFunction() throws Exception {
        List parameters = this.function.getParameters();
        if (parameters.isEmpty() || parameters.size() == 1) {
            throw new ASTValidationException("The function " + this.function.getName() + " requires at least two parameters", (ASTItem)this.function);
        }
        ASTOperandBase firstParam = (ASTOperandBase)parameters.get(0);
        if (parameters.size() <= 3) {
            if (!(firstParam instanceof ASTOperandProperty || firstParam instanceof ASTOperandFunction || firstParam instanceof ASTOperandVariable)) {
                throw new ASTValidationException("The function " + this.function.getName() + " has to be applied on an array property or a nested function. Currently applied on " + firstParam.getClass().getSimpleName(), (ASTItem)this.function);
            }
            if (firstParam.getDataType() != DataPropertyType.Array) {
                throw new ASTValidationException("The function " + this.function.getName() + " has to be applied on a property of type 'Array'. But is applied on property of type '" + firstParam.getDataType() + "'", (ASTItem)this.function);
            }
            if (parameters.size() == 2) {
                ASTOperandBase secondParam = (ASTOperandBase)parameters.get(1);
                if (!(secondParam instanceof ASTOperandStaticNumber)) {
                    throw new ASTValidationException("The function " + this.function.getName() + " takes an integer as the second parameter. Current second parameter is " + secondParam.getClass().getSimpleName(), (ASTItem)this.function);
                }
            } else {
                ASTOperandBase secondParam = (ASTOperandBase)parameters.get(1);
                if (!(secondParam instanceof ASTOperandLambdaCondition)) {
                    throw new ASTValidationException("The function " + this.function.getName() + " takes a lambda condition as the second parameter. Current second parameter is " + secondParam.getClass().getSimpleName(), (ASTItem)this.function);
                }
                ASTOperandBase thirdParam = (ASTOperandBase)parameters.get(2);
                if (!(thirdParam instanceof ASTOperandStaticNumber)) {
                    throw new ASTValidationException("The function " + this.function.getName() + " takes an integer as the third parameter. Current third parameter is " + thirdParam.getClass().getSimpleName(), (ASTItem)this.function);
                }
            }
        }
    }
}

