/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.core.validation.functions;

import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.ASTOperandFunction;
import io.openvalidation.common.ast.operand.ASTOperandVariable;
import io.openvalidation.common.ast.operand.lambda.ASTOperandLambdaProperty;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.exceptions.ASTValidationException;
import io.openvalidation.core.validation.functions.FunctionValidatorBase;
import java.util.List;

public class FunctionGetArrayOfValidator
extends FunctionValidatorBase {
    public FunctionGetArrayOfValidator(ASTOperandFunction function) {
        this.function = function;
    }

    @Override
    public void validateFunction() throws Exception {
        List parameters = this.function.getParameters();
        if (parameters.size() != 2) {
            throw new ASTValidationException("Incorrect parameter. The function " + this.function.getName() + " requires a property parameter formatted like this: '[array property containing objects].[attribute]' (where attribute is a property of each object contained in the array)\n<TECHNICAL ERROR> ARGUMENTS REQUIRED: 2, FOUND: " + parameters.size(), (ASTItem)this.function);
        }
        ASTOperandBase firstParam = (ASTOperandBase)parameters.get(0);
        if (!(firstParam instanceof ASTOperandProperty || firstParam instanceof ASTOperandFunction || firstParam instanceof ASTOperandVariable)) {
            throw new ASTValidationException("The first parameter of the function " + this.function.getName() + " has to be an array property or a nested function. Currently applied on " + firstParam.getClass().getSimpleName(), (ASTItem)this.function);
        }
        if (firstParam.getDataType() != DataPropertyType.Array) {
            throw new ASTValidationException("The first parameter of the function " + this.function.getName() + " has to be an array property of type 'Array'. Type found: " + firstParam.getDataType(), (ASTItem)this.function);
        }
        ASTOperandBase secondParam = (ASTOperandBase)parameters.get(1);
        if (!(secondParam instanceof ASTOperandLambdaProperty)) {
            throw new ASTValidationException("The second parameter of the function " + this.function.getName() + " has to be a subproperty of the objects contained in the first parameter", (ASTItem)this.function);
        }
    }
}

