/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.core.validation;

import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.ASTModel;
import io.openvalidation.core.validation.ValidationContext;
import io.openvalidation.core.validation.ValidatorFactory;

public abstract class ValidatorBase {
    protected ASTModel ast;
    protected ValidationContext context;
    protected int globalPosition;

    public ValidatorBase() {
    }

    public ValidatorBase(ValidationContext context) {
        this.setContext(context, -1);
    }

    public void setContext(ValidationContext context, int globalPosition) {
        this.context = context;
        this.ast = context.getAst();
        this.globalPosition = globalPosition;
    }

    public void setContext(ValidationContext context) {
        this.setContext(context, -1);
    }

    public abstract void validate() throws Exception;

    protected void validate(ASTItem item) throws Exception {
        this.validate(item, -1);
    }

    protected void validate(ASTItem item, int position) throws Exception {
        ValidatorBase validator = ValidatorFactory.Create(item);
        validator.setContext(this.context, position);
        validator.validate();
    }
}

