/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.core.validation;

import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.condition.ASTConditionBase;
import io.openvalidation.common.ast.operand.lambda.ASTOperandLambdaCondition;
import io.openvalidation.common.exceptions.ASTValidationException;
import io.openvalidation.core.validation.ValidatorBase;

public class ASTOperandLambdaConditionValidator
extends ValidatorBase {
    private ASTOperandLambdaCondition lambdaCondition;

    public ASTOperandLambdaConditionValidator(ASTOperandLambdaCondition lambdaCondition) {
        this.lambdaCondition = lambdaCondition;
    }

    @Override
    public void validate() throws Exception {
        if (this.lambdaCondition.getLambdaToken() == null || this.lambdaCondition.getLambdaToken().isEmpty()) {
            throw new ASTValidationException("A lambda condition requires a lambda token. Current token has value '" + this.lambdaCondition.getLambdaToken() + "'", (ASTItem)this.lambdaCondition);
        }
        if (this.lambdaCondition.getOperand() == null) {
            throw new ASTValidationException("A lambda condition requires an operand", (ASTItem)this.lambdaCondition);
        }
        if (!(this.lambdaCondition.getOperand() instanceof ASTConditionBase)) {
            throw new ASTValidationException("A lambda condition requires an instance of type ASTConditionBase as the operator. Current operand is instance of type '" + this.lambdaCondition.getOperand().getClass().getSimpleName() + "'", (ASTItem)this.lambdaCondition);
        }
        this.validate((ASTItem)this.lambdaCondition.getOperand());
    }
}

