/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.core.validation;

import io.openvalidation.common.ast.ASTGlobalElement;
import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.exceptions.ASTValidationException;
import io.openvalidation.common.exceptions.ASTValidationSummaryException;
import io.openvalidation.common.log.ProcessLogger;
import io.openvalidation.common.utils.StringUtils;
import io.openvalidation.core.validation.ValidationContext;
import io.openvalidation.core.validation.ValidatorBase;

public class ASTModelValidator
extends ValidatorBase {
    public ASTModelValidator(ValidationContext context) {
        super(context);
    }

    @Override
    public void validate() throws Exception {
        ASTValidationSummaryException exceptionSummary = new ASTValidationSummaryException(this.ast);
        try {
            if (this.ast.hasSource() && !this.ast.hasValidElements()) {
                if (!this.ast.getPreprocessedSource().contains("\u02ac") && StringUtils.match((String)this.ast.getPreprocessedSource(), (String)"\\b[A-Z]+\\b")) {
                    throw new ASTValidationException("the content of Rule Set doesn't match current language/culture '" + this.context.getOptions().getLocale() + "'", (ASTItem)this.ast);
                }
                throw new ASTValidationException("the Rule Set has invalid content", (ASTItem)this.ast);
            }
            for (ASTGlobalElement element : this.ast.getElements()) {
                try {
                    this.validate((ASTItem)element);
                }
                catch (ASTValidationException exp) {
                    exceptionSummary.add(exp);
                }
            }
            if (exceptionSummary.hasErrors()) {
                throw exceptionSummary;
            }
            ProcessLogger.success((String)ProcessLogger.VALIDATOR);
        }
        catch (Exception e) {
            ProcessLogger.error((String)ProcessLogger.VALIDATOR, (Exception)e);
            throw e;
        }
    }
}

