/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.core.validation;

import io.openvalidation.common.ast.ASTComparisonOperator;
import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.condition.ASTCondition;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.ASTOperandStatic;
import io.openvalidation.common.ast.operand.ASTOperandStaticString;
import io.openvalidation.common.ast.operand.lambda.ASTOperandLambdaCondition;
import io.openvalidation.common.exceptions.ASTValidationException;
import io.openvalidation.core.validation.ValidatorBase;

public class ASTConditionValidator
extends ValidatorBase {
    private ASTCondition _condition;
    private int _level;

    public ASTConditionValidator(ASTCondition condition) {
        this._condition = condition;
    }

    public void setLevel(int level) {
        this._level = level;
    }

    @Override
    public void validate() throws Exception {
        ASTOperandBase leftOperand = this._condition.getLeftOperand();
        ASTOperandBase rightOperand = this._condition.getRightOperand();
        ASTComparisonOperator operator = this._condition.getOperator();
        if (this._level > 0 && this._condition.getConnector() == null) {
            throw new ASTValidationException("missing Connector in combined condition.", (ASTItem)this._condition, this.globalPosition);
        }
        if (this._condition.getOperator() == null) {
            throw new ASTValidationException("invalid condition. missing comparison operator and operand.", (ASTItem)this._condition, this.globalPosition);
        }
        if (leftOperand == null && rightOperand == null) {
            throw new ASTValidationException("at least one operand should be present.", (ASTItem)this._condition, this.globalPosition);
        }
        if (operator.equals((Object)ASTComparisonOperator.EXISTS) || operator.equals((Object)ASTComparisonOperator.NOT_EXISTS)) {
            if (leftOperand == null || !leftOperand.hasValue()) {
                throw new ASTValidationException("missing left operand in EXISTS expression", (ASTItem)this._condition, this.globalPosition);
            }
            if (leftOperand.hasValue() && leftOperand instanceof ASTOperandStatic) {
                if (leftOperand instanceof ASTOperandStaticString) {
                    throw new ASTValidationException("Exists-operator cannot be used on plain text. Property required instead.", (ASTItem)this._condition);
                }
                throw new ASTValidationException("Exists-operator cannot be used on numbers. Property required instead.", (ASTItem)this._condition, this.globalPosition);
            }
            if (rightOperand != null) {
                throw new ASTValidationException("right operand in EXISTS expression is not allowed", (ASTItem)this._condition, this.globalPosition);
            }
        } else {
            if (leftOperand == null || !leftOperand.hasValue()) {
                throw new ASTValidationException("missing left operand in condition.", (ASTItem)this._condition, this.globalPosition);
            }
            if (rightOperand == null || !rightOperand.hasValue()) {
                throw new ASTValidationException("missing right operand in condition.", (ASTItem)this._condition, this.globalPosition);
            }
        }
        if (leftOperand != null) {
            this.validate((ASTItem)leftOperand, this.globalPosition);
        }
        if (rightOperand != null) {
            this.validate((ASTItem)rightOperand, this.globalPosition);
        }
        if (this._condition.getRightOperand() instanceof ASTOperandLambdaCondition) {
            // empty if block
        }
        if (!(rightOperand == null || leftOperand.getDataType() == rightOperand.getDataType() || operator == ASTComparisonOperator.AT_LEAST_ONE_OF || operator == ASTComparisonOperator.NONE_OF || operator == ASTComparisonOperator.ONE_OF || leftOperand.isEnumData() && rightOperand.isStringData() || rightOperand.isEnumData() && leftOperand.isStringData())) {
            throw new ASTValidationException("comparison contains different DataTypes. \nleft operand is of type: '" + leftOperand.getDataType() + "' and right operand is of type: '" + rightOperand.getDataType() + "'", (ASTItem)this._condition, this.globalPosition);
        }
        if (leftOperand instanceof ASTOperandStatic && rightOperand instanceof ASTOperandStatic) {
            throw new ASTValidationException("at least one operand in comparison should not be static\nleft operand is of type: '" + leftOperand.getType() + "' and right operand is of type: '" + rightOperand.getType() + "'", (ASTItem)this._condition, this.globalPosition);
        }
        if (this._condition.getUnresolvedConditions() != null && this._condition.getUnresolvedConditions().size() > 0) {
            throw new ASTValidationException("missing AND/OR connector in combined condition.", (ASTItem)this._condition.getUnresolvedConditions().get(0), this.globalPosition);
        }
    }
}

