/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.core.preprocessing.steps;

import io.openvalidation.common.data.DataPropertyBase;
import io.openvalidation.common.exceptions.ASTValidationException;
import io.openvalidation.common.utils.LINQ;
import io.openvalidation.common.utils.NameMasking;
import io.openvalidation.common.utils.StringUtils;
import io.openvalidation.core.Aliases;
import io.openvalidation.core.preprocessing.PreProcessorStepBase;
import java.util.ArrayList;
import java.util.List;

public class PreProcessorVariableNamesStep
extends PreProcessorStepBase {
    @Override
    public String process(String rule) throws Exception {
        List<String> variableNames = this.parseVariableNames(rule);
        if (variableNames != null && variableNames.size() > 0) {
            List duplicatedNames = LINQ.findDuplicates(variableNames);
            if (duplicatedNames != null && duplicatedNames.size() > 0) {
                throw new ASTValidationException("duplicate variable names found: " + StringUtils.join((List)duplicatedNames, (String)","));
            }
            ArrayList<String> wrongNames = new ArrayList<String>();
            for (String name : variableNames) {
                DataPropertyBase property = this.getContext().getSchema().getPropertyIfIsInPath(name);
                if (property == null) continue;
                wrongNames.add(name + " -> " + property.getFullNameLowerCase());
            }
            if (wrongNames.size() > 0) {
                throw new ASTValidationException("variable names schould not be named as schema attributes: " + StringUtils.join(wrongNames, (String)","));
            }
            ArrayList<String> wrongNamesAsAlias = new ArrayList<String>();
            for (String name : variableNames) {
                String unmaskedname = StringUtils.reverseKeywords((String)name);
                if (!Aliases.hasAlias(unmaskedname, this.getContext().getLocale())) continue;
                wrongNamesAsAlias.add(unmaskedname);
            }
            if (wrongNamesAsAlias.size() > 0) {
                throw new ASTValidationException("variable names schould not be named as reserved KEYWORD: " + StringUtils.join(wrongNamesAsAlias, (String)","));
            }
            for (String name : variableNames) {
                rule = rule.replaceAll(name, StringUtils.reverseKeywords((String)name));
            }
        }
        return rule;
    }

    public List<String> parseVariableNames(String rule) {
        List itemss;
        ArrayList<String> out = new ArrayList<String>();
        if (!StringUtils.isNullOrEmpty((String)rule) && (itemss = StringUtils.splitAndRemoveEmpty((String)rule, (String)"\u02acparagraph\u02ac")) != null) {
            for (String item : itemss) {
                String varName;
                int start;
                int pos;
                if (item.contains("\u02acif\u02ac") || item.contains("\u02acconstraint\u02acmust") || item.contains("\u02acconstraint\u02acmustnot") || !item.contains("\u02acas\u02ac") || (pos = item.indexOf("\u02acas\u02ac")) <= -1 || (start = item.indexOf(" ", pos)) <= -1 || StringUtils.isNullOrEmpty((String)(varName = item.substring(start + 1).trim()))) continue;
                out.add(varName);
            }
        }
        return out;
    }

    public String replaceVariableNames(String preprocessedRule) {
        String out = "";
        if (!StringUtils.isNullOrEmpty((String)preprocessedRule)) {
            List itemss = StringUtils.splitAndRemoveEmpty((String)preprocessedRule, (String)"\u02acparagraph\u02ac");
            if (itemss != null) {
                for (String item : itemss) {
                    String varName;
                    int start;
                    int pos;
                    if (!(item.contains("\u02acif\u02ac") || item.contains("\u02acconstraint\u02acmust") || item.contains("\u02acconstraint\u02acmustnot") || !item.contains("\u02acas\u02ac") || (pos = item.indexOf("\u02acas\u02ac")) <= -1 || (start = item.indexOf(" ", pos)) <= -1 || StringUtils.isNullOrEmpty((String)(varName = item.substring(start + 1).trim())))) {
                        item = item.replace(varName, NameMasking.maskVariableName((String)varName));
                    }
                    out = out + item + "\u02acparagraph\u02ac";
                }
            }
        } else {
            out = preprocessedRule;
        }
        return out;
    }
}

