/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.core.preprocessing.steps;

import io.openvalidation.common.log.ProcessLogger;
import io.openvalidation.common.utils.FileSystemUtils;
import io.openvalidation.core.Aliases;
import io.openvalidation.core.preprocessing.PreProcessorStepBase;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;

public class PreProcessorIncludeResolutionStep
extends PreProcessorStepBase {
    @Override
    public String process(String rule) throws Exception {
        try {
            String processedRule = this.resolveIncludes(rule, new ArrayList<String>(), 0);
            ProcessLogger.success((String)ProcessLogger.PREPROCESSOR_RESOLVE_INCLUDES);
            return processedRule;
        }
        catch (Exception e) {
            ProcessLogger.error((String)ProcessLogger.PREPROCESSOR);
            ProcessLogger.error((String)ProcessLogger.PREPROCESSOR_RESOLVE_INCLUDES, (Exception)e);
            throw e;
        }
    }

    private String resolveIncludes(String plainRule, List<String> includeRegister, int level) throws Exception {
        String rule = Aliases.resolve(plainRule, "INCLUDE", this.getContext().getLocale());
        for (String line : rule.split("\\n|\\r\\n")) {
            if (!line.contains("INCLUDE")) continue;
            String includePath = line.replace("INCLUDE", "").trim();
            if (!Paths.get(includePath = Matcher.quoteReplacement(includePath), new String[0]).isAbsolute() && this.getContext().hasWorkingDirectory()) {
                String inclFile = includePath;
                for (String basePath : this.getContext().getWorkingDirectory()) {
                    inclFile = Paths.get(basePath, includePath).toString();
                    if (!FileSystemUtils.fileExists((String)inclFile)) continue;
                    includePath = inclFile;
                    break;
                }
            }
            FileSystemUtils.fileShouldExists((String)includePath, (String)("an INCLUDE File: " + includePath + " could not be found." + System.lineSeparator() + "Rule Content: " + System.lineSeparator() + System.lineSeparator() + plainRule + System.lineSeparator()));
            if (includeRegister.contains(includePath)) {
                throw new RuntimeException("a circular reference detected while resolving INCLUDES. " + includePath + System.lineSeparator() + System.lineSeparator() + plainRule);
            }
            String includePlainContent = FileSystemUtils.readFile((String)includePath);
            if (includePlainContent == null) continue;
            includeRegister.add(includePath);
            includePlainContent = this.resolveIncludes(includePlainContent, includeRegister, level + 2);
            String formatString = "%" + level * 4 + "s";
            String spaces = level < 1 ? "" : String.format(formatString, " ");
            rule = rule.replaceAll(Matcher.quoteReplacement(line), includePlainContent.trim() + System.lineSeparator() + System.lineSeparator());
        }
        return rule;
    }
}

