/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.core;

import io.openvalidation.common.converter.SchemaConverterFactory;
import io.openvalidation.common.data.DataSchema;
import io.openvalidation.common.exceptions.OpenValidationException;
import io.openvalidation.common.model.ContentOptionKind;
import io.openvalidation.common.model.Language;
import io.openvalidation.common.model.Languages;
import io.openvalidation.common.utils.FileSystemUtils;
import io.openvalidation.common.validation.Validator;
import io.openvalidation.core.Aliases;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OpenValidationOptions {
    private String _outputDirectory = FileSystemUtils.getExecutingDirectory();
    private Locale _locale = Locale.getDefault();
    private String _outCodeFileName = "OpenValidation";
    private ContentOptionKind _ruleOptionKind;
    private String _ruleContent;
    private boolean _verbose;
    private Language _language = Languages.getLanguage((String)"Java");
    private Map<String, Object> _params;
    private List<String> _workingDirectories = new ArrayList<String>();
    private DataSchema _schema;
    private boolean _singleFile;
    private boolean _hasFileOutput;
    private String _packageName;
    private String _outImplementationClassName;
    private String _modelType;

    public OpenValidationOptions() {
        this.addWorkingDirectory(FileSystemUtils.getWorkingDirectory());
    }

    public String getOutputCodeFileName() {
        return this._outCodeFileName;
    }

    public void setOutputCodeFileName(String name) {
        this._outCodeFileName = name;
    }

    public String getOutputDirectory() {
        return this._outputDirectory.toLowerCase();
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    public boolean isVerbose() {
        return this._verbose;
    }

    public Map<String, Object> getParams() {
        return this._params;
    }

    public void setParams(Map<String, Object> params) {
        this._params = params;
        this.adjustParams();
    }

    public void setParam(String paramName, String value) {
        if (this._params == null) {
            this._params = new HashMap<String, Object>();
        }
        this._params.put(paramName, value);
        this.adjustParams();
    }

    public void setParam(String paramName, Object value) {
        if (this._params == null) {
            this._params = new HashMap<String, Object>();
        }
        this._params.put(paramName, value);
        this.adjustParams();
    }

    public void setOutputDirectory(String fileOrFolderPath) {
        this.setFileOutput(true);
        if (FileSystemUtils.isFile((String)fileOrFolderPath)) {
            this._outCodeFileName = FileSystemUtils.getFileNameWithoutExtension((String)fileOrFolderPath);
            String dir = FileSystemUtils.getDirectory((String)fileOrFolderPath);
            if (dir != null) {
                this._outputDirectory = dir;
            }
        } else {
            this._outputDirectory = fileOrFolderPath;
        }
    }

    public String resolveCodeFileName() {
        return Paths.get(this._outputDirectory, this._outCodeFileName).toString() + "." + this._language.getExtension();
    }

    public String resolveCodeFileName(String name) {
        return Paths.get(this._outputDirectory, name).toString() + "." + this._language.getExtension();
    }

    public String resolveCodeFileName(Language language) {
        return Paths.get(this._outputDirectory, this._outCodeFileName).toString() + "." + language.getExtension();
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public void setLocale(String locale) throws Exception {
        if (!Aliases.availableCultures.contains(locale)) {
            throw new OpenValidationException("Language: '" + locale + "' could not be found. The following languages are currently available " + Aliases.availableCultures);
        }
        this.setLocale(new Locale(locale));
    }

    public void setLanguage(Language _language) {
        this._language = _language;
    }

    public Language getLanguage() {
        return this._language;
    }

    public ContentOptionKind getRuleOptionKind() {
        return this._ruleOptionKind;
    }

    public String getRuleContent() {
        return this._ruleContent;
    }

    public void setRuleOption(String ruleContentOrURLOrFilePath) throws Exception {
        Validator.shouldNotBeEmpty((String)ruleContentOrURLOrFilePath, (String)"the Rule Set");
        this._ruleOptionKind = FileSystemUtils.getContentKind((String)ruleContentOrURLOrFilePath.trim());
        this._ruleContent = ruleContentOrURLOrFilePath;
        if (this._ruleOptionKind == ContentOptionKind.URL || this._ruleOptionKind == ContentOptionKind.FilePath) {
            if (this._outCodeFileName == "OpenValidation") {
                this._outCodeFileName = FileSystemUtils.getFileNameWithoutExtension((String)ruleContentOrURLOrFilePath);
            }
            if (this._ruleOptionKind == ContentOptionKind.FilePath) {
                try {
                    this.addWorkingDirectory(FileSystemUtils.getDirectory((String)this._ruleContent));
                    this._ruleContent = this._ruleContent.replace("\r", "\\r").replace("\n", "\\n");
                }
                catch (InvalidPathException e) {
                    this._ruleOptionKind = ContentOptionKind.Content;
                }
            }
        }
    }

    public String[] getWorkingDirectories() {
        return this._workingDirectories.toArray(new String[0]);
    }

    public void setWorkingDirectories(String[] workingDirectories) {
        this._workingDirectories = Arrays.asList(workingDirectories);
    }

    public void addWorkingDirectory(String workingDirectory) {
        if (workingDirectory != null) {
            this._workingDirectories.add(workingDirectory);
        }
    }

    public DataSchema getSchema() {
        return this._schema;
    }

    public void setSchema(String schemaContentOrURLOrFilePath) throws Exception {
        Validator.shouldNotBeEmpty((String)schemaContentOrURLOrFilePath, (String)"Schema");
        ContentOptionKind kind = FileSystemUtils.getContentKind((String)schemaContentOrURLOrFilePath);
        String schemaContent = schemaContentOrURLOrFilePath;
        if (kind == ContentOptionKind.URL) {
            throw new OpenValidationException("NOT IMPLEMENTED: Reading Schema File from URL is not implemented!");
        }
        if (kind == ContentOptionKind.FilePath) {
            try {
                schemaContent = FileSystemUtils.readFile((String)schemaContentOrURLOrFilePath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._schema = SchemaConverterFactory.convert((String)schemaContent);
    }

    public boolean isSingleFile() {
        return this._singleFile;
    }

    public void setSingleFile(boolean _singleFile) {
        this._singleFile = _singleFile;
    }

    public boolean hasFileOutput() {
        return this._hasFileOutput;
    }

    public void setFileOutput(boolean hasFileOutput) {
        this._hasFileOutput = hasFileOutput;
    }

    public String getPackageName() {
        return this._packageName;
    }

    public void setPackageName(String packageName) {
        this._packageName = packageName;
    }

    public String getOutImplementationClassName() {
        return this._outImplementationClassName;
    }

    public void setOutImplementationClassName(String outImplementationClassName) {
        this._outImplementationClassName = outImplementationClassName;
    }

    public String getModelType() {
        return this._modelType;
    }

    public void setModelType(String _modelType) {
        this._modelType = _modelType;
    }

    private void adjustParams() {
        if (this._params.containsKey("model_type")) {
            this.setModelType(this._params.get("model_type").toString());
        }
        if (this._params.containsKey("generated_class_namespace")) {
            this.setPackageName(this._params.get("generated_class_namespace").toString());
        }
        if (this._params.containsKey("generated_class_name")) {
            this.setOutImplementationClassName(this._params.get("generated_class_name").toString());
        }
    }
}

